/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.configuration.predicate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import org.apache.sirona.configuration.predicate.Predicate;
import org.apache.sirona.spi.SPI;

public final class PredicateEvaluator {
    private static final String NOT = "!";
    private static final char SEPARATOR = ':';
    private final Map<String, Predicate> predicates = new HashMap<String, Predicate>();
    private final boolean truePredicate;
    private final boolean trueValue;

    public PredicateEvaluator(String configuration, String sep) {
        if (configuration != null && configuration.length() > 0) {
            String[] segments;
            PrefixPredicate prefixPredicate = new PrefixPredicate();
            SuffixPredicate suffixPredicate = new SuffixPredicate();
            RegexPredicate regexPredicate = new RegexPredicate();
            ContainersPredicate containersPredicate = new ContainersPredicate();
            this.predicates.put(prefixPredicate.prefix(), prefixPredicate);
            this.predicates.put(suffixPredicate.prefix(), suffixPredicate);
            this.predicates.put(regexPredicate.prefix(), regexPredicate);
            this.predicates.put(containersPredicate.prefix(), containersPredicate);
            this.predicates.put(TruePredicate.INSTANCE.prefix(), TruePredicate.INSTANCE);
            this.predicates.put("boolean", TruePredicate.INSTANCE);
            for (Predicate predicate : SPI.INSTANCE.find(Predicate.class, PredicateEvaluator.class.getClassLoader())) {
                this.predicates.put(predicate.prefix(), predicate);
            }
            for (String segment : segments = configuration.split(sep)) {
                String trim = segment.trim();
                int separator = trim.indexOf(58);
                if (separator <= 0 || trim.length() <= separator) {
                    throw new IllegalArgumentException("Need to specify a prefix, available are:" + this.predicates.keySet());
                }
                String prefix = trim.substring(0, separator);
                Predicate predicate = this.predicates.get(prefix);
                if (predicate == null) {
                    throw new IllegalArgumentException("Can't find prefix '" + prefix + "'");
                }
                if (predicate == TruePredicate.INSTANCE) {
                    this.predicates.clear();
                    this.trueValue = Boolean.parseBoolean(trim.substring(separator + 1));
                    this.truePredicate = true;
                    return;
                }
                String value = trim.substring(separator + 1);
                if (!value.startsWith(NOT)) {
                    predicate.addConfiguration(value, true);
                    continue;
                }
                predicate.addConfiguration(value.substring(1), false);
            }
            this.trueValue = false;
            this.truePredicate = false;
        } else {
            this.trueValue = false;
            this.truePredicate = false;
        }
        this.predicates.remove(TruePredicate.INSTANCE.prefix());
        this.predicates.remove("boolean");
    }

    public boolean matches(String value) {
        if (this.truePredicate) {
            return this.trueValue;
        }
        for (Predicate predicate : this.predicates.values()) {
            if (!predicate.matches(value)) continue;
            return true;
        }
        return false;
    }

    private static class RegexPredicate
    implements Predicate {
        private final Map<Pattern, Boolean> patterns = new HashMap<Pattern, Boolean>();

        private RegexPredicate() {
        }

        public String prefix() {
            return "regex";
        }

        public boolean matches(String value) {
            for (Map.Entry<Pattern, Boolean> p : this.patterns.entrySet()) {
                if (!p.getKey().matcher(value).matches()) continue;
                return p.getValue();
            }
            return false;
        }

        public void addConfiguration(String value, boolean negative) {
            this.patterns.put(Pattern.compile(value), negative);
        }
    }

    private static class PrefixPredicate
    implements Predicate {
        private final Map<String, Boolean> prefixes = new HashMap<String, Boolean>();

        private PrefixPredicate() {
        }

        public String prefix() {
            return "prefix";
        }

        public boolean matches(String value) {
            for (Map.Entry<String, Boolean> p : this.prefixes.entrySet()) {
                if (!value.startsWith(p.getKey())) continue;
                return p.getValue();
            }
            return false;
        }

        public void addConfiguration(String value, boolean negative) {
            this.prefixes.put(value, negative);
        }
    }

    private static class SuffixPredicate
    implements Predicate {
        private final Map<String, Boolean> suffixes = new HashMap<String, Boolean>();

        private SuffixPredicate() {
        }

        public String prefix() {
            return "suffix";
        }

        public boolean matches(String value) {
            for (Map.Entry<String, Boolean> p : this.suffixes.entrySet()) {
                if (!value.endsWith(p.getKey())) continue;
                return p.getValue();
            }
            return false;
        }

        public void addConfiguration(String value, boolean negative) {
            this.suffixes.put(value, negative);
        }
    }

    private static class TruePredicate
    implements Predicate {
        private static final TruePredicate INSTANCE = new TruePredicate();

        private TruePredicate() {
        }

        public String prefix() {
            return "true";
        }

        public boolean matches(String value) {
            return true;
        }

        public void addConfiguration(String value, boolean negative) {
        }
    }

    private static class ContainersPredicate
    implements Predicate {
        private final Collection<String> containers = new CopyOnWriteArraySet<String>();

        private ContainersPredicate() {
        }

        public String prefix() {
            return "container";
        }

        public boolean matches(String value) {
            for (String container : this.containers) {
                String sub;
                String sub2;
                if ("tomee".equalsIgnoreCase(container) || "openejb".equalsIgnoreCase(container)) {
                    String apache;
                    String org;
                    if (!(value.startsWith("org.") ? ((org = value.substring("org.".length())).startsWith("apache.") ? ContainersPredicate.isTomcat(apache = org.substring("apache.".length())) || apache.startsWith("tomee") || apache.startsWith("openejb") || apache.startsWith("xbean") || apache.startsWith("bval") || apache.startsWith("openjpa") || apache.startsWith("geronimo") || apache.startsWith("webbeans") || apache.startsWith("myfaces") || apache.startsWith("cxf") || apache.startsWith("neethi") || apache.startsWith("activemq") || apache.startsWith("commons") : org.startsWith("slf4j.") || org.startsWith("metatype") || org.startsWith("hsqldb") || org.startsWith("eclipse.jdt")) : value.startsWith("serp"))) continue;
                    return true;
                }
                if ("tomcat".equalsIgnoreCase(container)) {
                    String org;
                    if (!value.startsWith("org.") || !((org = value.substring("org.".length())).startsWith("apache.") ? ContainersPredicate.isTomcat(sub2 = value.substring("org.apache.".length())) : org.startsWith("eclipse.jdt"))) continue;
                    return true;
                }
                if (!"jvm".equalsIgnoreCase(container)) continue;
                if (value.startsWith("java") || value.startsWith("sun") || value.startsWith("com.sun") || value.startsWith("jdk.")) {
                    return true;
                }
                if (value.startsWith("org.") && ((sub = value.substring("org.".length())).startsWith("omg") || sub.startsWith("xml.sax.") || sub.startsWith("ietf") || sub.startsWith("jcp") || sub.startsWith("apache.xerces"))) {
                    return true;
                }
                int length = "org.apache.".length();
                if (value.length() < length || !(sub2 = value.substring("org.apache.".length())).startsWith("xerces")) continue;
                return true;
            }
            return false;
        }

        private static boolean isTomcat(String sub) {
            return sub.startsWith("juli.") || sub.startsWith("catalina.") || sub.startsWith("tomcat.") || sub.startsWith("jasper.") || sub.startsWith("coyote.") || sub.startsWith("naming.") || sub.startsWith("el.");
        }

        public void addConfiguration(String value, boolean negative) {
            this.containers.add(value);
        }
    }
}

