/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.math;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sirona.math.M2AwareStatisticalSummary;
import org.apache.sirona.store.counter.LeafCollectorCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregators {
    public static M2AwareStatisticalSummary aggregate(Collection<LeafCollectorCounter> statistics) {
        if (statistics == null) {
            return null;
        }
        Iterator<LeafCollectorCounter> iterator = statistics.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        LeafCollectorCounter current = iterator.next();
        long n = current.getHits();
        double min = current.getMin();
        double sum = current.getSum();
        double max = current.getMax();
        double m2 = current.getSecondMoment();
        double mean = current.getMean();
        while (iterator.hasNext()) {
            current = iterator.next();
            if (current.getMin() < min || Double.isNaN(min)) {
                min = current.getMin();
            }
            if (current.getMax() > max || Double.isNaN(max)) {
                max = current.getMax();
            }
            double oldN = n;
            double curN = current.getHits();
            n = (long)((double)n + curN);
            double meanDiff = current.getMean() - mean;
            mean = (sum += current.getSum()) / (double)n;
            m2 = m2 + current.getSecondMoment() + meanDiff * meanDiff * oldN * curN / (double)n;
        }
        double variance = n == 0L ? Double.NaN : (n == 1L ? 0.0 : m2 / (double)(n - 1L));
        return new M2AwareStatisticalSummary(mean, variance, n, max, min, sum, m2);
    }

    private Aggregators() {
    }
}

