/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.skype.portlet;

import java.io.IOException;
import java.net.URI;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.skype.SkypeBusinessProvider;
import org.exoplatform.webconferencing.skype.SkypeSettings;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SkypeBusinessProviderPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(SkypeBusinessProviderPortlet.class);
    private SpaceService spaceService;
    private WebConferencingService webConferencing;
    private SkypeBusinessProvider provider;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        this.webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
        try {
            this.provider = (SkypeBusinessProvider)this.webConferencing.getProvider("mssfb");
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Provider mssfb isn't an instance of " + SkypeBusinessProvider.class.getName()), (Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.provider != null) {
            try {
                URI redirectURI = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), "/portal/skype/call", null, null);
                SkypeSettings settings = this.provider.settings().redirectURI(redirectURI.toString()).build();
                String settingsJson = Utils.asJSON((Object)settings);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/webConferencing", "webConferencing").addScripts("\nwindow.require(['SHARED/webConferencing_mssfb'], function(mssfbProvider) {if (mssfbProvider) { mssfbProvider.configure(" + settingsJson + "); webConferencing.addProvider(mssfbProvider); webConferencing.update(); }}, function(err) {console.log('Error creating Skype For Business provider. Error loading module: ' + JSON.stringify(err));});");
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing Skype Calls portlet for user " + request.getRemoteUser()), (Throwable)e);
            }
        }
    }
}

