/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.stats.domain;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.smartactivitystream.stats.domain.FocusId;

@Entity(name="SmartActivityFocus")
@ExoEntity
@Table(name="ST_ACTIVITY_FOCUS")
@IdClass(value=FocusId.class)
@NamedQueries(value={@NamedQuery(name="SmartActivityFocus.findTotalCount", query="SELECT COUNT(f.activityId) FROM SmartActivityFocus f"), @NamedQuery(name="SmartActivityFocus.findFocus", query="SELECT f FROM SmartActivityFocus f WHERE f.userId = :userId AND f.activityId = :activityId AND f.startTime = :startTime"), @NamedQuery(name="SmartActivityFocus.findAllFocus", query="SELECT f FROM SmartActivityFocus f WHERE f.userId = :userId AND f.activityId = :activityId ORDER BY f.startTime")})
public class ActivityFocusEntity
implements Externalizable {
    public static final int CONTINOUS_SESSION_TIME = 20000;
    private static final Long NULL_LONG = new Long(-1L);
    public static final String TRACKER_VERSION = "1.0";
    @Id
    @Column(name="USER_ID", nullable=false)
    protected String userId;
    @Id
    @Column(name="ACTIVITY_ID", nullable=false)
    protected String activityId;
    @Id
    @Column(name="START_TIME", nullable=false)
    protected Long startTime;
    @Column(name="STOP_TIME", nullable=false)
    protected Long stopTime;
    @Column(name="TOTAL_SHOWN", nullable=false)
    protected Long totalShown;
    @Column(name="CONTENT_SHOWN")
    protected Long contentShown;
    @Column(name="CONVO_SHOWN")
    protected Long convoShown;
    @Column(name="CONTENT_HITS")
    protected Long contentHits;
    @Column(name="CONVO_HITS")
    protected Long convoHits;
    @Column(name="APP_HITS")
    protected Long appHits;
    @Column(name="PROFILE_HITS")
    protected Long profileHits;
    @Column(name="LINK_HITS")
    protected Long linkHits;
    @Column(name="TRACKER_VERSION", nullable=false)
    protected String trackerVersion;
    protected transient Long initTime = System.currentTimeMillis();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Long stopTime) {
        this.stopTime = stopTime;
    }

    public Long getTotalShown() {
        return this.totalShown;
    }

    public void setTotalShown(Long totalShow) {
        this.totalShown = totalShow;
    }

    public Long getContentShown() {
        return this.contentShown;
    }

    public void setContentShown(Long contentShow) {
        this.contentShown = contentShow;
    }

    public Long getConvoShown() {
        return this.convoShown;
    }

    public void setConvoShown(Long convoShow) {
        this.convoShown = convoShow;
    }

    public Long getContentHits() {
        return this.contentHits;
    }

    public void setContentHits(Long contentHits) {
        this.contentHits = contentHits;
    }

    public Long getConvoHits() {
        return this.convoHits;
    }

    public void setConvoHits(Long convoHits) {
        this.convoHits = convoHits;
    }

    public Long getAppHits() {
        return this.appHits;
    }

    public void setAppHits(Long appHits) {
        this.appHits = appHits;
    }

    public Long getProfileHits() {
        return this.profileHits;
    }

    public void setProfileHits(Long profileHits) {
        this.profileHits = profileHits;
    }

    public Long getLinkHits() {
        return this.linkHits;
    }

    public void setLinkHits(Long linkHits) {
        this.linkHits = linkHits;
    }

    public String getTrackerVersion() {
        return this.trackerVersion;
    }

    public void setTrackerVersion(String trackerVersion) {
        this.trackerVersion = trackerVersion;
    }

    @Transient
    public Long getInitTime() {
        return this.initTime;
    }

    @Transient
    public boolean isReady() {
        return System.currentTimeMillis() - this.initTime > 20000L;
    }

    @Transient
    public FocusId getId() {
        return new FocusId(this.userId, this.activityId, this.startTime);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.initTime);
        out.writeUTF(this.userId);
        out.writeUTF(this.activityId);
        out.writeUTF(this.trackerVersion);
        out.writeLong(this.startTime);
        out.writeLong(this.stopTime);
        out.writeLong(this.totalShown);
        out.writeLong(this.contentShown != null ? this.contentShown : NULL_LONG);
        out.writeLong(this.convoShown != null ? this.convoShown : NULL_LONG);
        out.writeLong(this.contentHits != null ? this.contentHits : NULL_LONG);
        out.writeLong(this.convoHits != null ? this.convoHits : NULL_LONG);
        out.writeLong(this.appHits != null ? this.appHits : NULL_LONG);
        out.writeLong(this.profileHits != null ? this.profileHits : NULL_LONG);
        out.writeLong(this.linkHits != null ? this.linkHits : NULL_LONG);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initTime = in.readLong();
        this.userId = in.readUTF();
        this.activityId = in.readUTF();
        this.trackerVersion = in.readUTF();
        this.startTime = in.readLong();
        this.stopTime = in.readLong();
        this.totalShown = in.readLong();
        Long l = in.readLong();
        this.contentShown = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.convoShown = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.contentHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.convoHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.appHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.profileHits = l != NULL_LONG ? l : null;
        l = in.readLong();
        this.linkHits = l != NULL_LONG ? l : null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.userId);
        s.append('@');
        s.append(this.activityId);
        s.append('-');
        s.append(this.startTime);
        s.append('-');
        s.append(this.stopTime);
        return s.toString();
    }
}

