/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.relevancy;

import java.util.Date;
import java.util.List;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.smartactivitystream.relevancy.dao.RelevanceDAO;
import org.exoplatform.smartactivitystream.relevancy.dao.RelevanceStatsDAO;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceEntity;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceId;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceStatsEntity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.picocontainer.Startable;

public class ActivityRelevancyService
implements Startable {
    protected final RelevanceDAO relevanceStorage;
    protected final RelevanceStatsDAO relevanceStats;
    protected static final Log LOG = ExoLogger.getLogger(ActivityRelevancyService.class);

    public ActivityRelevancyService(RelevanceDAO relevanceStorage) {
        this.relevanceStorage = relevanceStorage;
        this.relevanceStats = null;
    }

    public ActivityRelevancyService(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, OrganizationService organization, IdentityManager identityManager, IdentityStorage identityStorage, ActivityManager activityManager, RelevanceDAO relevanceStorage, RelevanceStatsDAO relevanceStats) {
        this.relevanceStorage = relevanceStorage;
        this.relevanceStats = relevanceStats;
    }

    public void start() {
    }

    public void stop() {
    }

    public void saveRelevance(RelevanceEntity relevance) {
        RelevanceEntity existingRelevance = (RelevanceEntity)this.relevanceStorage.find(new RelevanceId(relevance.getUserId(), relevance.getActivityId()));
        relevance.setUpdateDate(new Date());
        if (existingRelevance == null) {
            this.relevanceStorage.create(relevance);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Relevance created: " + relevance));
            }
        } else {
            this.relevanceStorage.update(relevance);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Relevance updated: " + relevance));
            }
        }
    }

    public void deleteRelevance(RelevanceEntity relevance) {
        this.relevanceStorage.delete(relevance);
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Relevance deleted: " + relevance));
        }
    }

    public RelevanceEntity findById(RelevanceId relevanceId) {
        return (RelevanceEntity)this.relevanceStorage.find(relevanceId);
    }

    public List<RelevanceStatsEntity> findUserStats(Date sinceDate) {
        return this.relevanceStats.findUsersStats(sinceDate);
    }

    public long getRelevanciesCount() {
        return this.relevanceStorage.findTotalCount();
    }
}

