/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa;

import java.lang.reflect.Array;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.addons.search.ExtendProfileFilter;
import org.exoplatform.social.addons.storage.dao.IdentityDAO;
import org.exoplatform.social.addons.storage.dao.jpa.query.ProfileQueryBuilder;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;

public class IdentityDAOImpl
extends GenericDAOJPAImpl<IdentityEntity, Long>
implements IdentityDAO {
    public IdentityEntity create(IdentityEntity entity) {
        IdentityEntity exists = this.findByProviderAndRemoteId(entity.getProviderId(), entity.getRemoteId());
        if (exists != null) {
            throw new EntityExistsException("Identity is existed with ProviderID=" + entity.getProviderId() + " and RemoteId=" + entity.getRemoteId());
        }
        return (IdentityEntity)super.create((Object)entity);
    }

    @Override
    public IdentityEntity findByProviderAndRemoteId(String providerId, String remoteId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.findByProviderAndRemoteId", IdentityEntity.class);
        query.setParameter("providerId", (Object)providerId);
        query.setParameter("remoteId", (Object)remoteId);
        try {
            return (IdentityEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public long countIdentityByProvider(String providerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.countIdentityByProvider", Long.class);
        query.setParameter("providerId", (Object)providerId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Long> getAllIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.getAllIds", Long.class);
        if (limit > 0) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public ListAccess<IdentityEntity> findIdentities(ExtendProfileFilter filter) {
        ProfileQueryBuilder qb = ProfileQueryBuilder.builder().withFilter(filter);
        TypedQuery[] queries = qb.build(this.getEntityManager());
        return new JPAListAccess<IdentityEntity>(IdentityEntity.class, queries[0], (TypedQuery<Long>)queries[1]);
    }

    public static class JPAListAccess<T>
    implements ListAccess<T> {
        private final TypedQuery<T> selectQuery;
        private final TypedQuery<Long> countQuery;
        private final Class<T> clazz;

        public JPAListAccess(Class<T> clazz, TypedQuery<T> selectQuery, TypedQuery<Long> countQuery) {
            this.clazz = clazz;
            this.selectQuery = selectQuery;
            this.countQuery = countQuery;
        }

        public T[] load(int offset, int limit) throws Exception, IllegalArgumentException {
            if (limit > 0 && offset >= 0) {
                this.selectQuery.setFirstResult(offset);
                this.selectQuery.setMaxResults(limit);
            } else {
                this.selectQuery.setMaxResults(Integer.MAX_VALUE);
            }
            List list = this.selectQuery.getResultList();
            if (list != null && list.size() > 0) {
                Object[] arr = (Object[])Array.newInstance(this.clazz, list.size());
                return list.toArray(arr);
            }
            return (Object[])Array.newInstance(this.clazz, 0);
        }

        public int getSize() throws Exception {
            return ((Long)this.countQuery.getSingleResult()).intValue();
        }
    }
}

