/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.addons.storage.entity.LikerEntity;
import org.exoplatform.social.addons.storage.entity.MentionEntity;
import org.exoplatform.social.addons.storage.entity.StreamItemEntity;
import org.json.JSONObject;

@Entity(name="SocActivity")
@ExoEntity
@Table(name="SOC_ACTIVITIES")
@NamedQueries(value={@NamedQuery(name="getActivityByComment", query="select a from SocActivity a join a.comments Comment where Comment.id = :COMMENT_ID"), @NamedQuery(name="SocActivity.migratePosterId", query="UPDATE SocActivity a SET a.posterId = :newId WHERE a.posterId = :oldId"), @NamedQuery(name="SocActivity.migrateOwnerId", query="UPDATE SocActivity a SET a.ownerId = :newId WHERE a.ownerId = :oldId"), @NamedQuery(name="SocActivity.getAllActivities", query="SELECT a FROM SocActivity a WHERE a.isComment = false AND a.parent IS NULL"), @NamedQuery(name="SocActivity.findCommentsOfActivity", query="SELECT a FROM SocActivity a WHERE a.parent.id = :activityId ORDER BY a.updatedDate ASC"), @NamedQuery(name="SocActivity.numberCommentsOfActivity", query="SELECT count(distinct a) FROM SocActivity a WHERE a.parent.id = :activityId"), @NamedQuery(name="SocActivity.findNewerCommentsOfActivity", query="SELECT a FROM SocActivity a WHERE a.parent.id = :activityId AND a.updatedDate > :sinceTime ORDER BY a.updatedDate ASC"), @NamedQuery(name="SocActivity.findOlderCommentsOfActivity", query="SELECT a FROM SocActivity a WHERE a.parent.id = :activityId AND a.updatedDate < :sinceTime ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getParentActivity", query="SELECT a FROM SocActivity a INNER JOIN a.comments c WHERE c.id = :commentId"), @NamedQuery(name="SocActivity.getActivityByOwner", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE a.hidden = false AND item.ownerId in (:owner) ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getOlderActivityByOwner", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE a.hidden = false AND a.updatedDate < :sinceTime AND item.ownerId in (:owner) ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getNewerActivityByOwner", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE a.hidden = false AND a.updatedDate > :sinceTime AND item.ownerId in (:owner) ORDER BY a.updatedDate ASC"), @NamedQuery(name="SocActivity.getActivityByOwnerAndProviderId", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE a.hidden = false AND a.providerId = :providerId AND item.ownerId in (:owner) ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getActivityFeedNoConnections", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  item.ownerId in (:owners)  ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getActivityFeed", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  ( item.ownerId in (:owners) OR    ( item.ownerId in (:connections) AND item.streamType = :connStreamType )  ) ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getNewerActivityFeedNoConnections", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  a.updatedDate > :sinceTime AND  item.ownerId in (:owners) ORDER BY a.updatedDate ASC"), @NamedQuery(name="SocActivity.getNewerActivityFeed", query="SELECT distinct a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  a.updatedDate > :sinceTime AND  ( item.ownerId in (:owners) OR    ( item.ownerId in (:connections) AND item.streamType = :connStreamType )  ) ORDER BY a.updatedDate ASC"), @NamedQuery(name="SocActivity.getOlderActivityFeedNoConnections", query="SELECT a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  a.updatedDate < :sinceTime AND  item.ownerId in (:owners) ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getOlderActivityFeed", query="SELECT a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  a.updatedDate < :sinceTime AND  ( item.ownerId in (:owners) OR    ( item.ownerId in (:connections) AND item.streamType = :connStreamType )  ) ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getActivityOfConnection", query="SELECT a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  item.ownerId in (:connections) AND  item.streamType = :connStreamType  ORDER BY a.updatedDate DESC"), @NamedQuery(name="SocActivity.getNewerActivityOfConnection", query="SELECT a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  a.updatedDate > :sinceTime AND  a.hidden = false AND  item.ownerId in (:connections) AND  item.streamType = :connStreamType  ORDER BY a.updatedDate ASC"), @NamedQuery(name="SocActivity.getOlderActivityOfConnection", query="SELECT a FROM SocActivity a join a.streamItems item WHERE  a.hidden = false AND  a.updatedDate < :sinceTime AND  a.hidden = false AND  item.ownerId in (:connections) AND  item.streamType = :connStreamType  ORDER BY a.updatedDate DESC")})
public class ActivityEntity
implements Serializable {
    private static final long serialVersionUID = -1489894321243127979L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_ACTIVITIES_ID", sequenceName="SEQ_SOC_ACTIVITIES_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_ACTIVITIES_ID")
    @Column(name="ACTIVITY_ID")
    private Long id;
    @Column(name="TITLE", nullable=false)
    private String title;
    @Column(name="TYPE")
    private String type;
    @Column(name="TITLE_ID")
    private String titleId;
    @Column(name="POSTED", nullable=false)
    protected Long posted;
    @Column(name="UPDATED_DATE", nullable=false)
    private Long updatedDate;
    @Column(name="POSTER_ID")
    private String posterId;
    @Column(name="OWNER_ID")
    private String ownerId;
    @Column(name="PERMALINK")
    private String permaLink;
    @Column(name="APP_ID")
    private String appId;
    @Column(name="EXTERNAL_ID")
    private String externalId;
    @Column(name="LOCKED", nullable=false)
    private Boolean locked = false;
    @Column(name="HIDDEN", nullable=false)
    private Boolean hidden = false;
    @Column(name="BODY", length=2000)
    private String body;
    @ElementCollection
    @CollectionTable(name="SOC_ACTIVITY_LIKERS", joinColumns={@JoinColumn(name="ACTIVITY_ID")})
    private Set<LikerEntity> likers = new HashSet<LikerEntity>();
    @ElementCollection
    @JoinTable(name="SOC_ACTIVITY_TEMPLATE_PARAMS", joinColumns={@JoinColumn(name="ACTIVITY_ID")})
    @MapKeyColumn(name="TEMPLATE_PARAM_KEY")
    @Column(name="TEMPLATE_PARAM_VALUE")
    private Map<String, String> templateParams = new LinkedHashMap<String, String>();
    @Column(name="IS_COMMENT")
    private boolean isComment = false;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_ID", nullable=true)
    private ActivityEntity parent;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="parent", fetch=FetchType.LAZY)
    private List<ActivityEntity> comments;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="activity", fetch=FetchType.LAZY)
    private Set<MentionEntity> mentions;
    @Column(name="PROVIDER_ID")
    private String providerId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="activity", fetch=FetchType.LAZY)
    private List<StreamItemEntity> streamItems;

    public ActivityEntity() {
        this.setPosted(new Date());
        this.setUpdatedDate(new Date());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public Date getPosted() {
        return this.posted != null && this.posted > 0L ? new Date(this.posted) : null;
    }

    public void setPosted(Date posted) {
        this.posted = posted != null ? posted.getTime() : 0L;
    }

    public Date getUpdatedDate() {
        return this.updatedDate != null && this.updatedDate > 0L ? new Date(this.updatedDate) : null;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate != null ? updatedDate.getTime() : 0L;
    }

    public String getPosterId() {
        return this.posterId;
    }

    public void setPosterId(String posterId) {
        this.posterId = posterId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getPermaLink() {
        return this.permaLink;
    }

    public void setPermaLink(String permaLink) {
        this.permaLink = permaLink;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void addLiker(String likerId) {
        LikerEntity liker = new LikerEntity(likerId);
        if (!this.likers.contains(liker)) {
            this.likers.add(liker);
        }
    }

    public Set<LikerEntity> getLikers() {
        return this.likers;
    }

    public Set<String> getLikerIds() {
        HashSet<String> ids = new HashSet<String>();
        for (LikerEntity liker : this.likers) {
            ids.add(liker.getLikerId());
        }
        return ids;
    }

    public void setLikerIds(Set<String> likerIds) {
        if (likerIds == null || likerIds.isEmpty()) {
            this.likers.clear();
        } else {
            Iterator<LikerEntity> itor = this.likers.iterator();
            while (itor.hasNext()) {
                LikerEntity liker = itor.next();
                if (likerIds.contains(liker.getLikerId())) continue;
                itor.remove();
            }
            for (String id : likerIds) {
                this.addLiker(id);
            }
        }
    }

    public Set<String> getMentionerIds() {
        HashSet<String> result = new HashSet<String>();
        if (this.mentions != null) {
            for (MentionEntity mention : this.mentions) {
                result.add(mention.getMentionId());
            }
        }
        return result;
    }

    public void setMentionerIds(Set<String> mentionerIds) {
        if (this.mentions == null) {
            this.mentions = new HashSet<MentionEntity>();
        }
        HashSet<String> mentionToAdd = new HashSet<String>(mentionerIds);
        HashSet<MentionEntity> mentioned = new HashSet<MentionEntity>(this.mentions);
        for (MentionEntity m : mentioned) {
            if (!mentionerIds.contains(m.getMentionId())) {
                this.mentions.remove(m);
                continue;
            }
            mentionToAdd.remove(m.getMentionId());
        }
        for (String mentionerId : mentionToAdd) {
            this.addMention(mentionerId);
        }
    }

    private void addMention(String mentionerId) {
        if (this.mentions == null) {
            this.mentions = new HashSet<MentionEntity>();
        }
        MentionEntity mention = new MentionEntity();
        mention.setMentionId(mentionerId);
        mention.setActivity(this);
        this.mentions.add(mention);
    }

    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(Map<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    public List<ActivityEntity> getComments() {
        return this.comments;
    }

    public void setComments(List<ActivityEntity> comments) {
        this.comments = comments;
    }

    public void addComment(ActivityEntity comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<ActivityEntity>();
        }
        comment.setParent(this);
        this.comments.add(comment);
    }

    public ActivityEntity getParent() {
        return this.parent;
    }

    public void setParent(ActivityEntity parent) {
        this.parent = parent;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public void setComment(boolean comment) {
        this.isComment = comment;
    }

    public List<StreamItemEntity> getStreamItems() {
        return this.streamItems;
    }

    public void setStreamItems(List<StreamItemEntity> streamItems) {
        this.streamItems = streamItems;
    }

    public void addStreamItem(StreamItemEntity item) {
        if (this.streamItems == null) {
            this.streamItems = new ArrayList<StreamItemEntity>();
        }
        item.setActivity(this);
        this.streamItems.add(item);
    }

    public void removeStreamItem(StreamItemEntity item) {
        for (StreamItemEntity it : this.getStreamItems()) {
            if (!it.getOwnerId().equals(item.getOwnerId()) || !it.getStreamType().equals((Object)item.getStreamType())) continue;
            this.streamItems.remove(it);
            break;
        }
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

