/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.addons.storage.dao.ConnectionDAO;
import org.exoplatform.social.addons.storage.dao.jpa.ConnectionDAOImpl$AjcClosure1;
import org.exoplatform.social.addons.storage.dao.jpa.query.RelationshipQueryBuilder;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;

public class ConnectionDAOImpl
extends GenericDAOJPAImpl<ConnectionEntity, Long>
implements ConnectionDAO {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @ExoTransactional
    public long count(Identity identity, Relationship.Type status) {
        Identity identity2 = identity;
        Relationship.Type type = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)identity2, (Object)type);
        Object[] objectArray = new Object[]{this, identity2, type, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new ConnectionDAOImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Override
    public ConnectionEntity getConnection(Identity identity1, Identity identity2) {
        TypedQuery<ConnectionEntity> query = RelationshipQueryBuilder.builder().sender(identity1).receiver(identity2).buildSingleRelationship();
        try {
            return (ConnectionEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            return (ConnectionEntity)query.getResultList().get(0);
        }
    }

    @Override
    public ConnectionEntity getConnection(Long sender, Long reciver) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocConnection.findConnectionBySenderAndReceiver", ConnectionEntity.class);
        query.setParameter("sender", (Object)sender);
        query.setParameter("reciver", (Object)reciver);
        query.setMaxResults(1);
        try {
            return (ConnectionEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<ConnectionEntity> getConnections(Identity identity, Relationship.Type type, long offset, long limit) {
        return RelationshipQueryBuilder.builder().owner(identity).status(type).offset(offset).limit(limit).build().getResultList();
    }

    @Override
    public List<ConnectionEntity> getConnections(Identity sender, Identity receiver, Relationship.Type status) {
        return RelationshipQueryBuilder.builder().sender(sender).receiver(receiver).status(status).build().getResultList();
    }

    @Override
    public int getConnectionsCount(Identity identity, Relationship.Type type) {
        Long id = Long.parseLong(identity.getId());
        long numberSender = 0L;
        long numberReceiver = 0L;
        if (type == Relationship.Type.INCOMING) {
            numberSender = this.countSenderId(id, Relationship.Type.PENDING);
        } else if (type == Relationship.Type.OUTGOING) {
            numberReceiver = this.countReceiverId(id, Relationship.Type.PENDING);
        } else {
            numberSender = this.countSenderId(id, type);
            numberReceiver = this.countReceiverId(id, type);
        }
        return (int)(numberSender + numberReceiver);
    }

    @Override
    public List<ConnectionEntity> getLastConnections(Identity identity, int limit) {
        return RelationshipQueryBuilder.builder().owner(identity).status(Relationship.Type.CONFIRMED).offset(0L).limit(limit).buildLastConnections().getResultList();
    }

    @Override
    public List<ConnectionEntity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit) {
        return RelationshipQueryBuilder.builder().owner(existingIdentity).status(type).offset(0L).limit(limit).filter(profileFilter).buildFilter().getResultList();
    }

    @Override
    public int getConnectionsByFilterCount(Identity identity, ProfileFilter profileFilter, Relationship.Type type) {
        return ((Long)RelationshipQueryBuilder.builder().owner(identity).status(type).filter(profileFilter).buildFilterCount().getSingleResult()).intValue();
    }

    @Override
    public List<Long> getSenderIds(long receiverId, Relationship.Type status, int offset, int limit) {
        Relationship.Type[] typeArray;
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("SocConnection.getSenderByReceiverAndStatus", Long.class);
        query.setParameter("receiverId", (Object)receiverId);
        if (status == Relationship.Type.ALL) {
            typeArray = Relationship.Type.values();
        } else {
            Relationship.Type[] typeArray2 = new Relationship.Type[1];
            typeArray = typeArray2;
            typeArray2[0] = status;
        }
        List<Relationship.Type> st = Arrays.asList(typeArray);
        query.setParameter("status", st);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<Long> getReceiverIds(long receiverId, Relationship.Type status, int offset, int limit) {
        Relationship.Type[] typeArray;
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("SocConnection.getReceiverBySenderAndStatus", Long.class);
        query.setParameter("senderId", (Object)receiverId);
        if (status == Relationship.Type.ALL) {
            typeArray = Relationship.Type.values();
        } else {
            Relationship.Type[] typeArray2 = new Relationship.Type[1];
            typeArray = typeArray2;
            typeArray2[0] = status;
        }
        List<Relationship.Type> st = Arrays.asList(typeArray);
        query.setParameter("status", st);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    private Long countSenderId(long receiverId, Relationship.Type status) {
        Relationship.Type[] typeArray;
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("SocConnection.countSenderByReceiverAndStatus", Long.class);
        query.setParameter("receiverId", (Object)receiverId);
        if (status == Relationship.Type.ALL || status == null) {
            typeArray = Relationship.Type.values();
        } else {
            Relationship.Type[] typeArray2 = new Relationship.Type[1];
            typeArray = typeArray2;
            typeArray2[0] = status;
        }
        List<Relationship.Type> st = Arrays.asList(typeArray);
        query.setParameter("status", st);
        return (Long)query.getSingleResult();
    }

    private Long countReceiverId(long sender, Relationship.Type status) {
        Relationship.Type[] typeArray;
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("SocConnection.countReceiverBySenderAndStatus", Long.class);
        query.setParameter("senderId", (Object)sender);
        if (status == Relationship.Type.ALL || status == null) {
            typeArray = Relationship.Type.values();
        } else {
            Relationship.Type[] typeArray2 = new Relationship.Type[1];
            typeArray = typeArray2;
            typeArray2[0] = status;
        }
        List<Relationship.Type> st = Arrays.asList(typeArray);
        query.setParameter("status", st);
        return (Long)query.getSingleResult();
    }

    static {
        ConnectionDAOImpl.ajc$preClinit();
    }

    static /* synthetic */ long count_aroundBody0(ConnectionDAOImpl ajc$this, Identity identity, Relationship.Type status, JoinPoint joinPoint) {
        return (Long)RelationshipQueryBuilder.builder().owner(identity).status(status).buildCount().getSingleResult();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConnectionDAOImpl.java", ConnectionDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "count", "org.exoplatform.social.addons.storage.dao.jpa.ConnectionDAOImpl", "org.exoplatform.social.core.identity.model.Identity:org.exoplatform.social.core.relationship.model.Relationship$Type", "identity:status", "", "long"), 50);
    }
}

