/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.search;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.es.domain.Document;
import org.exoplatform.addons.es.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.addons.storage.dao.ConnectionDAO;
import org.exoplatform.social.addons.storage.dao.IdentityDAO;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.json.simple.JSONObject;

public class ProfileIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(ProfileIndexingServiceConnector.class);
    public static final String TYPE = "profile";
    private final IdentityManager identityManager;
    private final ConnectionDAO connectionDAO;
    private final IdentityDAO identityDAO;

    public ProfileIndexingServiceConnector(InitParams initParams, IdentityManager identityManager, IdentityDAO identityDAO, ConnectionDAO connectionDAO) {
        super(initParams);
        this.identityManager = identityManager;
        this.identityDAO = identityDAO;
        this.connectionDAO = connectionDAO;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    private String buildConnectionString(Identity identity, Relationship.Type type) {
        int offset;
        StringBuilder sb = new StringBuilder();
        int limit = 200;
        List<Long> list = null;
        long id = Long.parseLong(identity.getId());
        boolean inSender = true;
        boolean inReceiver = true;
        if (type == Relationship.Type.OUTGOING) {
            inSender = false;
            type = Relationship.Type.PENDING;
        } else if (type == Relationship.Type.INCOMING) {
            inReceiver = false;
            type = Relationship.Type.PENDING;
        }
        if (inSender) {
            offset = 0;
            do {
                list = this.connectionDAO.getSenderIds(id, type, offset, 200);
                sb = this.append(sb, list);
                offset += 200;
            } while (list.size() >= 200);
        }
        if (inReceiver) {
            offset = 0;
            do {
                list = this.connectionDAO.getReceiverIds(id, type, offset, 200);
                sb = this.append(sb, list);
                offset += 200;
            } while (list.size() >= 200);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private StringBuilder append(StringBuilder sb, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return sb;
        }
        int len = ids.size() * 10;
        if (sb.capacity() < sb.length() + len) {
            sb = new StringBuilder(sb.capacity() + len).append((CharSequence)sb);
        }
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb;
    }

    public List<String> getAllIds(int offset, int limit) {
        List<Long> ids = this.identityDAO.getAllIdsByProvider("organization", offset, limit);
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            result.add(String.valueOf(id));
        }
        return result;
    }

    public String getMapping() {
        JSONObject postingHighlighterField = new JSONObject();
        postingHighlighterField.put((Object)"type", (Object)"string");
        postingHighlighterField.put((Object)"index_options", (Object)"offsets");
        JSONObject notAnalyzedField = new JSONObject();
        notAnalyzedField.put((Object)"type", (Object)"string");
        notAnalyzedField.put((Object)"index", (Object)"not_analyzed");
        JSONObject properties = new JSONObject();
        properties.put((Object)"permissions", (Object)notAnalyzedField);
        properties.put((Object)"sites", (Object)notAnalyzedField);
        properties.put((Object)"userName", (Object)notAnalyzedField);
        properties.put((Object)"email", (Object)notAnalyzedField);
        properties.put((Object)"name", (Object)postingHighlighterField);
        properties.put((Object)"firstName", (Object)postingHighlighterField);
        properties.put((Object)"lastName", (Object)postingHighlighterField);
        properties.put((Object)"position", (Object)postingHighlighterField);
        properties.put((Object)"skills", (Object)postingHighlighterField);
        JSONObject mappingProperties = new JSONObject();
        mappingProperties.put((Object)"properties", (Object)properties);
        JSONObject mappingJSON = new JSONObject();
        mappingJSON.put((Object)this.getType(), (Object)mappingProperties);
        return mappingJSON.toJSONString();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long ts = System.currentTimeMillis();
        LOG.debug("get profile document for identity id={}", new Object[]{id});
        Identity identity = this.identityManager.getIdentity(id, true);
        Profile profile = identity.getProfile();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", profile.getFullName());
        fields.put("firstName", (String)profile.getProperty("firstName"));
        fields.put("lastName", (String)profile.getProperty("lastName"));
        fields.put("position", profile.getPosition());
        fields.put("skills", (String)profile.getProperty("skills"));
        fields.put("avatarUrl", profile.getAvatarUrl());
        fields.put("userName", identity.getRemoteId());
        fields.put("email", profile.getEmail());
        Date createdDate = new Date(profile.getCreatedTime());
        String connectionsStr = this.buildConnectionString(identity, Relationship.Type.CONFIRMED);
        if (connectionsStr.length() > 0) {
            fields.put("connections", connectionsStr);
        }
        if ((connectionsStr = this.buildConnectionString(identity, Relationship.Type.OUTGOING)).length() > 0) {
            fields.put("outgoings", connectionsStr);
        }
        if ((connectionsStr = this.buildConnectionString(identity, Relationship.Type.INCOMING)).length() > 0) {
            fields.put("incomings", connectionsStr);
        }
        Document document = new Document(TYPE, id, null, createdDate, (Set)null, fields);
        LOG.info("profile document generated for identity id={} remote_id={} duration_ms={}", new Object[]{id, identity.getRemoteId(), System.currentTimeMillis() - ts});
        return document;
    }
}

