/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.addons.rest.IdentityAvatarRestService;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;
import org.exoplatform.social.addons.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityConverterUtils {
    public static Identity convertToIdentity(IdentityEntity entity) {
        return EntityConverterUtils.convertToIdentity(entity, true);
    }

    public static Identity convertToIdentity(IdentityEntity entity, boolean mapDeleted) {
        if (entity.isDeleted() && !mapDeleted) {
            return null;
        }
        Identity identity = new Identity(entity.getStringId());
        EntityConverterUtils.mapToIdentity(entity, identity);
        return identity;
    }

    public static void mapToIdentity(IdentityEntity entity, Identity identity) {
        identity.setProviderId(entity.getProviderId());
        identity.setRemoteId(entity.getRemoteId());
        identity.setProfile(EntityConverterUtils.convertToProfile(entity, identity));
        identity.setEnable(entity.isEnabled());
        identity.setDeleted(entity.isDeleted());
    }

    public static Profile convertToProfile(IdentityEntity entity, Identity identity) {
        Profile p = new Profile(identity);
        p.setId(String.valueOf(identity.getId()));
        EntityConverterUtils.mapToProfile(entity, p);
        if ("organization".equals(identity.getProviderId()) && p.getProperty("username") == null) {
            p.getProperties().put("username", identity.getRemoteId());
        }
        return p;
    }

    public static void mapToProfile(IdentityEntity entity, Profile p) {
        Map<String, String> properties = entity.getProperties();
        Map props = p.getProperties();
        String providerId = entity.getProviderId();
        if (!"organization".equals(providerId) && !"space".equals(providerId)) {
            p.setUrl(properties.get("Url"));
            p.setAvatarUrl(properties.get("avatarUrl"));
        } else {
            String remoteId = entity.getRemoteId();
            if ("organization".equals(providerId)) {
                p.setUrl(LinkProvider.getUserProfileUri((String)remoteId));
            } else if ("space".equals(providerId)) {
                p.setUrl(LinkProvider.getSpaceUri((String)remoteId));
            }
            if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L) {
                Identity identity = p.getIdentity();
                p.setAvatarUrl(IdentityAvatarRestService.buildAvatarURL(identity.getProviderId(), identity.getRemoteId()));
            }
        }
        StringBuilder skills = new StringBuilder();
        StringBuilder positions = new StringBuilder();
        Set<ProfileExperienceEntity> experiences = entity.getExperiences();
        if (experiences != null && experiences.size() > 0) {
            ArrayList xpData = new ArrayList();
            for (ProfileExperienceEntity exp : experiences) {
                HashMap<String, Object> xpMap = new HashMap<String, Object>();
                if (exp.getSkills() != null && !exp.getSkills().isEmpty()) {
                    skills.append(exp.getSkills()).append(",");
                }
                if (exp.getPosition() != null && !exp.getPosition().isEmpty()) {
                    positions.append(exp.getPosition()).append(",");
                }
                xpMap.put("skills", exp.getSkills());
                xpMap.put("position", exp.getPosition());
                xpMap.put("startDate", exp.getStartDate());
                xpMap.put("endDate", exp.getEndDate());
                xpMap.put("company", exp.getCompany());
                xpMap.put("description", exp.getDescription());
                xpMap.put("isCurrent", exp.isCurrent());
                xpData.add(xpMap);
            }
            props.put("experiences", xpData);
        }
        if (skills.length() > 0) {
            skills.deleteCharAt(skills.length() - 1);
            props.put("skills", skills.toString());
        }
        if (positions.length() > 0) {
            positions.deleteCharAt(positions.length() - 1);
            props.put("position", positions.toString());
        }
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if ("ims".equals(key) || "phones".equals(key) || "urls".equals(key)) {
                    ArrayList list = new ArrayList();
                    try {
                        JSONArray arr = new JSONArray(value);
                        for (int i = 0; i < arr.length(); ++i) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            JSONObject json = arr.getJSONObject(i);
                            Iterator keys = json.keys();
                            while (keys.hasNext()) {
                                String k = (String)keys.next();
                                map.put(k, json.optString(k));
                            }
                            list.add(map);
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    props.put(key, list);
                    continue;
                }
                if ("Url".equals(key)) continue;
                props.put(key, value);
            }
        }
        p.setCreatedTime(Long.valueOf(entity.getCreatedDate().getTime()));
        p.setLastLoaded(System.currentTimeMillis());
    }

    public static void mapToEntity(Identity identity, IdentityEntity entity) {
        entity.setProviderId(identity.getProviderId());
        entity.setRemoteId(identity.getRemoteId());
        entity.setEnabled(identity.isEnable());
        entity.setDeleted(identity.isDeleted());
    }

    public static long parseId(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public static List<IdentityWithRelationship> convertToIdentitiesWithRelationship(ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list, int offset, int limit) {
        try {
            if (list == null) {
                return Collections.emptyList();
            }
            Map.Entry[] entities = (Map.Entry[])list.load(offset, limit);
            ArrayList<IdentityWithRelationship> result = new ArrayList<IdentityWithRelationship>(limit);
            for (Map.Entry tuple : entities) {
                IdentityEntity identityEntity = (IdentityEntity)tuple.getKey();
                ConnectionEntity connectionEntity = (ConnectionEntity)tuple.getValue();
                IdentityWithRelationship identityWithRelationship = new IdentityWithRelationship(identityEntity.getStringId());
                EntityConverterUtils.mapToIdentity(identityEntity, (Identity)identityWithRelationship);
                Relationship relationship = EntityConverterUtils.convertRelationshipItemToRelationship(connectionEntity);
                identityWithRelationship.setRelationship(relationship);
                result.add(identityWithRelationship);
            }
            return result;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static List<Identity> convertToIdentities(ListAccess<IdentityEntity> list, long offset, long limit) {
        try {
            return EntityConverterUtils.convertToIdentities((IdentityEntity[])list.load((int)offset, (int)limit));
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static List<Identity> convertToIdentities(IdentityEntity[] entities) {
        if (entities == null || entities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Identity> result = new ArrayList<Identity>(entities.length);
        for (IdentityEntity entity : entities) {
            Identity idt = EntityConverterUtils.convertToIdentity(entity);
            if (idt == null) continue;
            result.add(idt);
        }
        return result;
    }

    public static Relationship convertRelationshipItemToRelationship(ConnectionEntity item) {
        if (item == null) {
            return null;
        }
        Relationship relationship = new Relationship(Long.toString(item.getId()));
        relationship.setId(String.valueOf(item.getId()));
        relationship.setSender(EntityConverterUtils.convertToIdentity(item.getSender()));
        relationship.setReceiver(EntityConverterUtils.convertToIdentity(item.getReceiver()));
        relationship.setStatus(item.getStatus());
        return relationship;
    }
}

