/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.addons.search.ExtendProfileFilter;
import org.exoplatform.social.addons.storage.dao.IdentityDAO;
import org.exoplatform.social.addons.storage.dao.jpa.query.ProfileQueryBuilder;
import org.exoplatform.social.addons.storage.entity.ConnectionEntity;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;

public class IdentityDAOImpl
extends GenericDAOJPAImpl<IdentityEntity, Long>
implements IdentityDAO {
    private static final Log LOG = ExoLogger.getLogger(IdentityDAOImpl.class);

    public IdentityEntity create(IdentityEntity entity) {
        IdentityEntity exists = this.findByProviderAndRemoteId(entity.getProviderId(), entity.getRemoteId());
        if (exists != null) {
            throw new EntityExistsException("Identity is existed with ProviderID=" + entity.getProviderId() + " and RemoteId=" + entity.getRemoteId());
        }
        return (IdentityEntity)super.create((Object)entity);
    }

    @Override
    public IdentityEntity findByProviderAndRemoteId(String providerId, String remoteId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.findByProviderAndRemoteId", IdentityEntity.class);
        query.setParameter("providerId", (Object)providerId);
        query.setParameter("remoteId", (Object)remoteId);
        try {
            return (IdentityEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public long countIdentityByProvider(String providerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.countIdentityByProvider", Long.class);
        query.setParameter("providerId", (Object)providerId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Long> getAllIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.getAllIds", Long.class);
        if (limit > 0) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public List<Long> getAllIdsByProvider(String providerId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.getAllIdsByProvider", Long.class);
        query.setParameter("providerId", (Object)providerId);
        if (limit > 0) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    @Override
    public ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> findAllIdentitiesWithConnections(long identityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SocIdentity.findIdentitiesByProviderWithExcludedIdentity", IdentityEntity.class);
        query.setParameter("identityId", (Object)identityId);
        query.setParameter("providerId", (Object)"organization");
        TypedQuery connectionsQuery = this.getEntityManager().createNamedQuery("SocConnection.findConnectionsByIdentityIds", ConnectionEntity.class);
        TypedQuery countQuery = this.getEntityManager().createNamedQuery("SocIdentity.countIdentitiesByProviderWithExcludedIdentity", Long.class);
        countQuery.setParameter("identityId", (Object)identityId);
        countQuery.setParameter("providerId", (Object)"organization");
        return new IdentityWithRelationshipListAccess((TypedQuery<IdentityEntity>)query, (TypedQuery<ConnectionEntity>)connectionsQuery, (TypedQuery<Long>)countQuery);
    }

    @Override
    public ListAccess<IdentityEntity> findIdentities(ExtendProfileFilter filter) {
        if (filter.getConnection() != null) {
            Relationship.Type status;
            Identity owner = filter.getConnection();
            Long ownerId = Long.valueOf(owner.getId());
            List<Long> connections = this.getConnections(ownerId, status = filter.getConnectionStatus());
            if (connections.isEmpty()) {
                return new JPAListAccess<IdentityEntity>(IdentityEntity.class);
            }
            if (filter.getIdentityIds() == null || filter.getIdentityIds().isEmpty()) {
                filter.setIdentityIds(connections);
            } else {
                filter.getIdentityIds().retainAll(connections);
            }
        }
        ProfileQueryBuilder qb = ProfileQueryBuilder.builder().withFilter(filter);
        TypedQuery[] queries = qb.build(this.getEntityManager());
        return new JPAListAccess<IdentityEntity>(IdentityEntity.class, queries[0], (TypedQuery<Long>)queries[1]);
    }

    private List<Long> getConnections(Long ownerId, Relationship.Type status) {
        String queryName = null;
        Class returnType = null;
        if (status == null || status == Relationship.Type.ALL) {
            queryName = "SocConnection.getConnectionsWithoutStatus";
            returnType = ConnectionEntity.class;
        } else if (status == Relationship.Type.INCOMING) {
            queryName = "SocConnection.getSenderIdsByReceiverWithStatus";
            returnType = Long.class;
            status = Relationship.Type.PENDING;
        } else if (status == Relationship.Type.OUTGOING) {
            queryName = "SocConnection.getReceiverIdsBySenderWithStatus";
            returnType = Long.class;
            status = Relationship.Type.PENDING;
        } else {
            queryName = "SocConnection.getConnectionsWithStatus";
            returnType = ConnectionEntity.class;
        }
        Query query = this.getEntityManager().createNamedQuery(queryName);
        query.setParameter("identityId", (Object)ownerId);
        if (status != null && status != Relationship.Type.ALL) {
            query.setParameter("status", (Object)status);
        }
        if (returnType == Long.class) {
            return query.getResultList();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        List connectionEntities = query.getResultList();
        for (ConnectionEntity connectionEntity : connectionEntities) {
            if (connectionEntity.getReceiver().getId() == ownerId.longValue()) {
                ids.add(connectionEntity.getSender().getId());
                continue;
            }
            if (connectionEntity.getSender().getId() == ownerId.longValue()) {
                ids.add(connectionEntity.getReceiver().getId());
                continue;
            }
            LOG.warn("Neither sender neither receiver corresponds to owner with id {}. ", new Object[]{ownerId});
        }
        return ids;
    }

    public static class IdentityWithRelationshipListAccess
    implements ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> {
        private final TypedQuery<IdentityEntity> identityQuery;
        private final TypedQuery<ConnectionEntity> connectionsQuery;
        private final TypedQuery<Long> countQuery;

        public IdentityWithRelationshipListAccess(TypedQuery<IdentityEntity> identityQuery, TypedQuery<ConnectionEntity> connctionsQuery, TypedQuery<Long> countQuery) {
            this.identityQuery = identityQuery;
            this.connectionsQuery = connctionsQuery;
            this.countQuery = countQuery;
        }

        public Map.Entry<IdentityEntity, ConnectionEntity>[] load(int offset, int limit) throws Exception, IllegalArgumentException {
            if (limit > 0 && offset >= 0) {
                this.identityQuery.setFirstResult(offset);
                this.identityQuery.setMaxResults(limit);
            } else {
                this.identityQuery.setMaxResults(Integer.MAX_VALUE);
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            List identitiesList = this.identityQuery.getResultList();
            for (IdentityEntity identityEntity : identitiesList) {
                ids.add(identityEntity.getId());
            }
            if (ids.isEmpty()) {
                return new Map.Entry[0];
            }
            this.connectionsQuery.setParameter("identityId", this.identityQuery.getParameterValue("identityId"));
            this.connectionsQuery.setParameter("ids", ids);
            this.connectionsQuery.setMaxResults(Integer.MAX_VALUE);
            List connectionsList = this.connectionsQuery.getResultList();
            HashMap<IdentityEntity, ConnectionEntity> map = new HashMap<IdentityEntity, ConnectionEntity>();
            block1: for (IdentityEntity identityEntity : identitiesList) {
                map.put(identityEntity, null);
                for (ConnectionEntity connectionEntity : connectionsList) {
                    if (connectionEntity.getReceiver().getId() != identityEntity.getId() && connectionEntity.getSender().getId() != identityEntity.getId()) continue;
                    map.put(identityEntity, connectionEntity);
                    continue block1;
                }
            }
            return map.entrySet().toArray(new Map.Entry[0]);
        }

        public int getSize() throws Exception {
            return ((Long)this.countQuery.getSingleResult()).intValue();
        }
    }

    public static class JPAListAccess<T>
    implements ListAccess<T> {
        private final TypedQuery<T> selectQuery;
        private final TypedQuery<Long> countQuery;
        private final Class<T> clazz;

        public JPAListAccess(Class<T> clazz) {
            this.clazz = clazz;
            this.selectQuery = null;
            this.countQuery = null;
        }

        public JPAListAccess(Class<T> clazz, TypedQuery<T> selectQuery, TypedQuery<Long> countQuery) {
            this.clazz = clazz;
            this.selectQuery = selectQuery;
            this.countQuery = countQuery;
        }

        public T[] load(int offset, int limit) throws Exception, IllegalArgumentException {
            if (this.selectQuery == null) {
                return (Object[])Array.newInstance(this.clazz, 0);
            }
            if (limit > 0 && offset >= 0) {
                this.selectQuery.setFirstResult(offset);
                this.selectQuery.setMaxResults(limit);
            } else {
                this.selectQuery.setMaxResults(Integer.MAX_VALUE);
            }
            List list = this.selectQuery.getResultList();
            if (list != null && list.size() > 0) {
                Object[] arr = (Object[])Array.newInstance(this.clazz, list.size());
                return list.toArray(arr);
            }
            return (Object[])Array.newInstance(this.clazz, 0);
        }

        public int getSize() throws Exception {
            if (this.countQuery == null) {
                return 0;
            }
            return ((Long)this.countQuery.getSingleResult()).intValue();
        }
    }
}

