/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.spacesadministration;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.MembershipEntry;

public class SpacesAdministrationStorage {
    private Log log = ExoLogger.getLogger(SpacesAdministrationStorage.class);
    public static final String SETTINGS_NODE_WORKSPACE = "social";
    public static final String SETTINGS_NODE_PATH = "exo:applications/spacesadministration";
    public static final String SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY = "soc:createMemberships";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean settingsEntityExists() throws Exception {
        Session session = null;
        try {
            session = this.getSession();
            boolean bl = session.getRootNode().hasNode(SETTINGS_NODE_PATH);
            return bl;
        }
        catch (RepositoryException e) {
            this.log.error((Object)("Error while checking spaces administration settings node existence - Cause : " + e.getMessage()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSettingsEntity() throws Exception {
        Session session = null;
        try {
            session = this.getSession();
            Node settingsNode = session.getRootNode().addNode(SETTINGS_NODE_PATH);
            settingsNode.setProperty(SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY, "");
            session.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpaceCreationMembership(MembershipEntry membership) throws Exception {
        if (membership == null) {
            throw new IllegalArgumentException("Cannot add null membership");
        }
        String membershipToAdd = membership.getMembershipType() + ":" + membership.getGroup();
        Session session = null;
        try {
            String currentCreateSpaceMemberships;
            session = this.getSession();
            if (!session.getRootNode().hasNode(SETTINGS_NODE_PATH)) {
                throw new Exception("Spaces Administration Settings Node does not exist - Cannot add the membership " + membershipToAdd);
            }
            Node settingsNode = session.getRootNode().getNode(SETTINGS_NODE_PATH);
            String newMembership = membership.getMembershipType() + ":" + membership.getGroup();
            String newCreateSpaceMemberships = currentCreateSpaceMemberships = settingsNode.getProperty(SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY).getString();
            if (!currentCreateSpaceMemberships.isEmpty()) {
                String[] currentCreateSpaceMembershipsArray;
                for (String currentCreateSpaceMembership : currentCreateSpaceMembershipsArray = currentCreateSpaceMemberships.split(",")) {
                    if (!currentCreateSpaceMembership.equals(newMembership)) continue;
                    return;
                }
                newCreateSpaceMemberships = newCreateSpaceMemberships + ",";
            }
            newCreateSpaceMemberships = newCreateSpaceMemberships + newMembership;
            settingsNode.setProperty(SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY, newCreateSpaceMemberships);
            settingsNode.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MembershipEntry> getSpaceCreationMemberships() throws Exception {
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        Session session = null;
        try {
            session = this.getSession();
            if (session.getRootNode().hasNode(SETTINGS_NODE_PATH)) {
                Node settingsNode = session.getRootNode().getNode(SETTINGS_NODE_PATH);
                String createSpaceMemberships = settingsNode.getProperty(SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY).getString();
                if (createSpaceMemberships != null && !createSpaceMemberships.trim().isEmpty()) {
                    String[] createSpaceMembershipsSplitted;
                    for (String createMembership : createSpaceMembershipsSplitted = createSpaceMemberships.split(",")) {
                        String[] createSpaceMembershipSplitted = createMembership.split(":");
                        if (createSpaceMembershipSplitted.length == 2) {
                            memberships.add(new MembershipEntry(createSpaceMembershipSplitted[1], createSpaceMembershipSplitted[0]));
                            continue;
                        }
                        this.log.warn((Object)("Wrong format for spaces administration membership : " + createMembership));
                    }
                }
                ArrayList<MembershipEntry> arrayList = memberships;
                return arrayList;
            }
            List<MembershipEntry> list = null;
            return list;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpaceCreationMembership(MembershipEntry membership) throws Exception {
        if (membership == null) {
            throw new IllegalArgumentException("Cannot delete null membership");
        }
        String membershipToDelete = membership.getMembershipType() + ":" + membership.getGroup();
        Session session = null;
        try {
            session = this.getSession();
            if (!session.getRootNode().hasNode(SETTINGS_NODE_PATH)) {
                throw new Exception("Spaces Administration Settings Node does not exist - Cannot delete the membership " + membershipToDelete);
            }
            Node settingsNode = session.getRootNode().getNode(SETTINGS_NODE_PATH);
            String currentCreateSpaceMemberships = settingsNode.getProperty(SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY).getString();
            String[] currentCreateSpaceMembershipsArray = currentCreateSpaceMemberships.split(",");
            StringBuilder newCreateSpaceMemberships = new StringBuilder();
            for (String currentCreateSpaceMembership : currentCreateSpaceMembershipsArray) {
                if (currentCreateSpaceMembership.equals(membershipToDelete)) continue;
                newCreateSpaceMemberships.append(currentCreateSpaceMembership + ",");
            }
            if (newCreateSpaceMemberships.length() > 0) {
                newCreateSpaceMemberships.deleteCharAt(newCreateSpaceMemberships.length() - 1);
            }
            settingsNode.setProperty(SETTINGS_NODE_CREATE_MEMBERSHIP_PROPERTY, newCreateSpaceMemberships.toString());
            settingsNode.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSettingsEntity() throws RepositoryException {
        Session session = null;
        try {
            session = this.getSession();
            if (session.getRootNode().hasNode(SETTINGS_NODE_PATH)) {
                Node settingsNode = session.getRootNode().getNode(SETTINGS_NODE_PATH);
                settingsNode.remove();
                session.save();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public Session getSession() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        return sessionProviderService.getSystemSessionProvider(null).getSession(SETTINGS_NODE_WORKSPACE, repository);
    }
}

