/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.spacesadministration;

import java.util.List;
import org.exoplatform.addons.spacesadministration.JCRSpacesAdministrationStorage;
import org.exoplatform.addons.spacesadministration.SettingsSpacesAdministrationStorage;
import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.MembershipEntry;

public class SpacesAdministrationSettingsMigration
implements StartableClusterAware {
    private Log log = ExoLogger.getLogger(SpacesAdministrationSettingsMigration.class);
    private JCRSpacesAdministrationStorage jcrSpacesAdministrationStorage;
    private SettingsSpacesAdministrationStorage settingsSpacesAdministrationStorage;

    public SpacesAdministrationSettingsMigration(JCRSpacesAdministrationStorage jcrSpacesAdministrationStorage, SettingsSpacesAdministrationStorage settingsSpacesAdministrationStorage) {
        this.jcrSpacesAdministrationStorage = jcrSpacesAdministrationStorage;
        this.settingsSpacesAdministrationStorage = settingsSpacesAdministrationStorage;
    }

    public void start() {
        try {
            this.log.info((Object)"== Starting migrating Spaces Administration data");
            List<MembershipEntry> spaceCreationMemberships = this.jcrSpacesAdministrationStorage.getSpaceCreationMemberships();
            if (spaceCreationMemberships != null) {
                for (MembershipEntry membershipEntry : spaceCreationMemberships) {
                    this.log.info((Object)("   * migrating membership " + membershipEntry.toString()));
                    this.settingsSpacesAdministrationStorage.addSpaceCreationMembership(membershipEntry);
                }
            } else {
                this.log.info((Object)"   * no membership to migrate");
            }
            this.log.info((Object)"== Cleaning old Spaces Administration data");
            this.jcrSpacesAdministrationStorage.deleteSettingsEntity();
            this.log.info((Object)"== Spaces Administration data migration done successfully");
        }
        catch (Exception e) {
            this.log.error((Object)"Error while migrating Spaces Administration data", (Throwable)e);
        }
    }

    public boolean isDone() {
        return !this.jcrSpacesAdministrationStorage.settingsEntityExists();
    }
}

