/*
 * Decompiled with CFR 0.152.
 */
package org.josso;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.ComponentKeeper;
import org.josso.ComponentKeeperFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.SSOWebConfiguration;
import org.josso.gateway.SecurityDomainRegistry;
import org.josso.gateway.assertion.AssertionManager;
import org.josso.gateway.event.client.SSOEventManagerClient;
import org.josso.gateway.identity.service.SSOIdentityProvider;

public class Lookup {
    private static final Log logger = LogFactory.getLog(Lookup.class);
    private String configResourceName;
    private static final Lookup INSTANCE = new Lookup();
    private ComponentKeeper _componentKeeper;
    private SSOGateway ssoGateway;

    private Lookup() {
    }

    public static Lookup getInstance() {
        return INSTANCE;
    }

    public void init(String configResourceName) {
        logger.info((Object)("Init resourceName <" + configResourceName + ">"));
        this.configResourceName = configResourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSOGateway lookupSSOGateway() throws Exception {
        if (this.ssoGateway == null) {
            Lookup lookup = this;
            synchronized (lookup) {
                if (this.ssoGateway == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Initializing JOSSO Gateway ... ");
                    }
                    this.ssoGateway = this.getComponentKeeper().fetchSSOGateway();
                    this.ssoGateway.initialize();
                }
            }
        }
        return this.ssoGateway;
    }

    public synchronized SecurityDomain lookupSecurityDomain() throws Exception {
        SSOContext ctx = SSOContext.getCurrent();
        if (ctx == null) {
            throw new IllegalStateException("No SSOContext found !");
        }
        SecurityDomain sd = ctx.getSecurityDomain();
        if (sd == null) {
            logger.warn((Object)("SecurityDomain is null for thread " + Thread.currentThread().getName()));
        }
        return sd;
    }

    public SSOWebConfiguration lookupSSOWebConfiguration() throws Exception {
        SecurityDomain sd = this.lookupSecurityDomain();
        return sd.getSSOWebConfiguration();
    }

    public SSOIdentityProvider lookupSSOIdentityProvider() throws Exception {
        SecurityDomain sd = this.lookupSecurityDomain();
        return sd.getIdentityProvider();
    }

    public AssertionManager lookupAssertionManager() throws Exception {
        SecurityDomain sd = this.lookupSecurityDomain();
        return sd.getAssertionManager();
    }

    public SSOEventManagerClient lookupSSOEventManagerClient() {
        try {
            return (SSOEventManagerClient)Class.forName("org.josso.gateway.event.client.SSOEventManagerClientImpl").newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("Cannot instantiate default event manager client : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public ComponentKeeper getComponentKeeper() throws Exception {
        if (this._componentKeeper == null) {
            ComponentKeeperFactory factory = ComponentKeeperFactory.getInstance();
            factory.setResourceFileName(this.configResourceName);
            this._componentKeeper = factory.newComponentKeeper();
            logger.info((Object)("Using ComponentKeeper : " + this._componentKeeper.getClass().getName()));
        }
        return this._componentKeeper;
    }

    public static void main(String[] args) throws Exception {
    }

    public SecurityDomainRegistry lookupSecurityDomainRegistry() throws Exception {
        return this.lookupSSOGateway().getSecurityDomainRegistry();
    }
}

