/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v1.writers.BaseSAML11Writer;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11AssertionWriter;
import org.picketlink.identity.federation.saml.common.CommonStatusDetailType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusCodeType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.w3c.dom.Element;

public class SAML11ResponseWriter
extends BaseSAML11Writer {
    protected String namespace = "urn:oasis:names:tc:SAML:1.0:protocol";
    protected SAML11AssertionWriter assertionWriter;

    public SAML11ResponseWriter(XMLStreamWriter writer) {
        super(writer);
        this.assertionWriter = new SAML11AssertionWriter(writer);
    }

    public void write(SAML11ResponseType response) throws ProcessingException {
        SAML11StatusType status;
        Element sig;
        URI recipient;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"Response", (String)this.namespace);
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)this.namespace);
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)"urn:oasis:names:tc:SAML:1.0:assertion");
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"ResponseID", (String)response.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"MajorVersion", (String)(response.getMajorVersion() + ""));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"MinorVersion", (String)(response.getMinorVersion() + ""));
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)response.getIssueInstant().toString());
        String inResp = response.getInResponseTo();
        if (StringUtil.isNotNull((String)inResp)) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"InResponseTo", (String)inResp);
        }
        if ((recipient = response.getRecipient()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Recipient", (String)recipient.toString());
        }
        if ((sig = response.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        if ((status = response.getStatus()) != null) {
            this.write(status);
        }
        List<SAML11AssertionType> assertions = response.get();
        for (SAML11AssertionType assertion : assertions) {
            this.assertionWriter.write(assertion);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11StatusType status) throws ProcessingException {
        CommonStatusDetailType details;
        String statusMsg;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"Status", (String)this.namespace);
        SAML11StatusCodeType statusCode = status.getStatusCode();
        if (statusCode != null) {
            this.write(statusCode);
        }
        if (StringUtil.isNotNull((String)(statusMsg = status.getStatusMessage()))) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"StatusMessage", (String)this.namespace);
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)statusMsg);
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((details = status.getStatusDetail()) != null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"StatusDetail", (String)this.namespace);
            List<Object> objs = details.getAny();
            for (Object theObj : objs) {
                StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)theObj.toString());
            }
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(SAML11StatusCodeType statusCode) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)"StatusCode", (String)this.namespace);
        QName value = statusCode.getValue();
        if (value == null) {
            throw logger.writerNullValueError("Attribute Value");
        }
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"Value", (QName)value);
        SAML11StatusCodeType secondCode = statusCode.getStatusCode();
        if (secondCode != null) {
            this.write(secondCode);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }
}

