/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.md.providers;

import java.io.InputStream;
import java.net.URI;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.identity.federation.core.interfaces.IMetadataProvider;
import org.picketlink.identity.federation.core.saml.md.providers.AbstractMetadataProvider;
import org.picketlink.identity.federation.core.saml.md.providers.MetadataProviderUtils;
import org.picketlink.identity.federation.saml.v2.metadata.AttributeConsumingServiceType;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedNameType;
import org.picketlink.identity.federation.saml.v2.metadata.RequestedAttributeType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;

public class SPMetadataProvider
extends AbstractMetadataProvider
implements IMetadataProvider<EntityDescriptorType> {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final String ENTITY_ID_KEY = "EntityId";
    private static final String PROTOCOL = "urn:oasis:names:tc:SAML:2.0:protocol";
    private static final String ATTRIBUTE_KEYS = "ATTRIBUTE_KEYS";
    private static final String SERVICE_NAME = "ServiceName";
    private String entityId;
    private String logoutPage;
    private String bindingUri;
    private String serviceUrl;
    private String logoutResponseLocation;
    private String serviceName;
    private String nameIdFormat;
    private PicketLinkType picketLinkType;

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.entityId = options.get(ENTITY_ID_KEY);
        if (this.entityId == null) {
            throw logger.optionNotSet(ENTITY_ID_KEY);
        }
        ProviderType providerType = MetadataProviderUtils.getProviderType(this.picketLinkType);
        String bindingURI = MetadataProviderUtils.getBindingURI(providerType);
        if (bindingURI == null) {
            throw new RuntimeException("bindingURI cannot be null");
        }
        this.logoutPage = MetadataProviderUtils.getLogoutURL(providerType);
        this.logoutResponseLocation = MetadataProviderUtils.getLogoutResponseLocation(providerType);
        this.bindingUri = bindingURI;
        this.serviceUrl = MetadataProviderUtils.getServiceURL(providerType);
        this.serviceName = options.get(SERVICE_NAME);
        this.nameIdFormat = this.getNameIdFormat();
    }

    @Override
    public EntityDescriptorType getMetaData() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add(PROTOCOL);
        SPSSODescriptorType spSSO = new SPSSODescriptorType(protocols);
        spSSO.setAuthnRequestsSigned(true);
        spSSO.setWantAssertionsSigned(true);
        if (this.bindingUri != null && this.logoutPage != null) {
            EndpointType endpointType = new EndpointType(URI.create(this.bindingUri), URI.create(this.logoutPage));
            endpointType.setResponseLocation(URI.create(this.logoutResponseLocation));
            spSSO.addSingleLogoutService(endpointType);
        }
        IndexedEndpointType assertionConsumerSvc = new IndexedEndpointType(URI.create(this.bindingUri), URI.create(this.serviceUrl));
        assertionConsumerSvc.setIsDefault(true);
        spSSO.addAssertionConsumerService(assertionConsumerSvc);
        if (this.serviceName != null) {
            spSSO.addAttributeConsumerService(this.getAttributeConsumerService());
            if (this.nameIdFormat != null) {
                spSSO.addNameIDFormat(this.nameIdFormat);
            }
        }
        EntityDescriptorType.EDTDescriptorChoiceType edtDescChoice = new EntityDescriptorType.EDTDescriptorChoiceType(spSSO);
        EntityDescriptorType.EDTChoiceType edtChoice = EntityDescriptorType.EDTChoiceType.oneValue(edtDescChoice);
        EntityDescriptorType entityDescriptor = new EntityDescriptorType(this.entityId);
        entityDescriptor.addChoiceType(edtChoice);
        return entityDescriptor;
    }

    private AttributeConsumingServiceType getAttributeConsumerService() {
        try {
            Handler attributeHandler = MetadataProviderUtils.getHandler(this.picketLinkType, "org.picketlink.identity.federation.web.handlers.saml2.SAML2AttributeHandler");
            List options = attributeHandler.getOption();
            ArrayList<String> attributeVals = new ArrayList<String>();
            for (Object option : options) {
                if (!option.getKey().equals(ATTRIBUTE_KEYS)) continue;
                for (String str : option.getValue().split(",")) {
                    attributeVals.add(str);
                }
            }
            AttributeConsumingServiceType attributeConsumingService = new AttributeConsumingServiceType(0);
            for (String attributeVal : attributeVals) {
                RequestedAttributeType requestedAttributeType = new RequestedAttributeType(attributeVal);
                requestedAttributeType.setIsRequired(true);
                requestedAttributeType.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.get());
                attributeConsumingService.addRequestedAttribute(requestedAttributeType);
            }
            LocalizedNameType serviceLocName = new LocalizedNameType(JBossSAMLConstants.LANG_EN.get());
            serviceLocName.setValue(this.serviceName);
            attributeConsumingService.addServiceName(serviceLocName);
            attributeConsumingService.setIsDefault(true);
            return attributeConsumingService;
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNameIdFormat() {
        try {
            Handler authHandler = MetadataProviderUtils.getHandler(this.picketLinkType, "org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler");
            List options = authHandler.getOption();
            for (KeyValueType option : options) {
                if (!option.getKey().equals("NAMEID_FORMAT")) continue;
                return option.getValue();
            }
            return null;
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPicketLinkConf(PicketLinkType picketLinkType) {
        this.picketLinkType = picketLinkType;
    }

    @Override
    public void injectFileStream(InputStream fileStream) {
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    @Override
    public String requireFileInjection() {
        return null;
    }

    @Override
    public void injectSigningKey(PublicKey publicKey) {
    }

    @Override
    public void injectEncryptionKey(PublicKey publicKey) {
    }
}

