/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.SSOInterceptor;
import org.gatein.sso.agent.filter.api.SSOInterceptorInitializationContext;
import org.gatein.sso.saml.plugin.filter.SAMLFilterConfig;
import org.gatein.sso.saml.plugin.filter.SAMLHTTPRequestWrapper;
import org.picketlink.identity.federation.web.filters.IDPFilter;

public class PortalIDPWebBrowserSSOFilter
extends IDPFilter
implements SSOInterceptor {
    public static final String ORIGINAL_HTTP_SERVLET_REQUEST_PARAM = "OriginalHttpServletRequest";
    private static final Logger log = LoggerFactory.getLogger(PortalIDPWebBrowserSSOFilter.class);
    protected FilterConfig config;
    protected String servletContextName;
    private volatile Boolean requirePortalEnvironment;
    private SSOInterceptorInitializationContext interceptorContext;

    public final void init(FilterConfig config) throws ServletException {
        this.config = this.getFilterConfig(config);
        this.servletContextName = ContainerUtil.getServletContextName((ServletContext)config.getServletContext());
        this.afterInit(config);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpSession session = httpServletRequest.getSession(true);
        Principal userPrincipal = httpServletRequest.getUserPrincipal();
        String samlRequestMessage = request.getParameter("SAMLRequest");
        if (userPrincipal == null && StringUtils.isNotBlank((String)samlRequestMessage)) {
            session.setAttribute(ORIGINAL_HTTP_SERVLET_REQUEST_PARAM, (Object)httpServletRequest);
            httpServletResponse.sendRedirect("/" + this.servletContextName + "/dologin?initialURI=" + URLEncoder.encode(httpServletRequest.getRequestURI(), "UTF-8"));
            return;
        }
        HttpServletRequest originalHttpServletRequest = (HttpServletRequest)session.getAttribute(ORIGINAL_HTTP_SERVLET_REQUEST_PARAM);
        if (originalHttpServletRequest != null) {
            request = new SAMLHTTPRequestWrapper(httpServletRequest, originalHttpServletRequest);
            session.removeAttribute(ORIGINAL_HTTP_SERVLET_REQUEST_PARAM);
        }
        super.doFilter(request, response, chain);
    }

    private final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = this.interceptorContext.getExoContainer();
        }
        if (container instanceof RootContainer) {
            container = PortalContainer.getInstance();
        }
        return container;
    }

    private final void afterInit(FilterConfig filterConfig) throws ServletException {
        this.interceptorContext = new SSOInterceptorInitializationContext(filterConfig, null, null);
        log.debug((Object)("Interceptor initialized with context " + this.interceptorContext));
        try {
            this.initImpl();
        }
        catch (ServletException e) {
            log.error((Object)"Error initializing SAML Filter", (Throwable)e);
        }
    }

    public final void initWithParams(InitParams params, ExoContainerContext containerContext) {
        this.interceptorContext = new SSOInterceptorInitializationContext(null, params, containerContext);
        this.servletContextName = containerContext.getPortalContainerName();
        log.debug((Object)("Interceptor initialized with context " + this.interceptorContext));
        try {
            this.initImpl();
        }
        catch (ServletException e) {
            log.error((Object)"Error initializing SAML Filter", (Throwable)e);
        }
    }

    protected void initImpl() throws ServletException {
        FilterConfig filterConfig = this.getFilterConfig(null);
        if (this.servletContextName == null) {
            this.servletContextName = ContainerUtil.getServletContextName((ServletContext)this.getServletContext());
        }
        filterConfig.getServletContext().setInitParameter("CONFIG_FILE", this.getInitParameter("CONFIG_FILE"));
        super.init(filterConfig);
    }

    protected String getInitParameter(String paramName) {
        return this.interceptorContext.getInitParameter(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requirePortalEnvironment() {
        if (this.requirePortalEnvironment == null) {
            PortalIDPWebBrowserSSOFilter portalIDPWebBrowserSSOFilter = this;
            synchronized (portalIDPWebBrowserSSOFilter) {
                if (this.requirePortalEnvironment == null) {
                    this.requirePortalEnvironment = PortalContainer.isPortalContainerName((String)this.servletContextName);
                }
            }
        }
        return this.requirePortalEnvironment;
    }

    protected ServletContext getServletContext() {
        ExoContainer container;
        if (this.requirePortalEnvironment() && (container = this.getContainer()) instanceof PortalContainer) {
            return ((PortalContainer)container).getPortalContext();
        }
        if (this.config != null) {
            return this.config.getServletContext();
        }
        return null;
    }

    private FilterConfig getFilterConfig(FilterConfig config) {
        if (this.config == null) {
            this.config = config == null ? new SAMLFilterConfig("PortalIDPWebBrowserSSOFilter", this.getServletContext(), this.interceptorContext) : config;
        }
        return this.config;
    }
}

