/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;

public class DefaultTokenRegistry
implements SecurityTokenRegistry {
    protected Map<String, Object> tokens = new ConcurrentHashMap<String, Object>();

    @Override
    public void addToken(String tokenID, Object token) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.tokens.put(tokenID, token);
    }

    @Override
    public Object getToken(String tokenID) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        return this.tokens.get(tokenID);
    }

    @Override
    public void removeToken(String tokenID) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.tokens.remove(tokenID);
    }
}

