/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.javaee;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.security.SecurityContext;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEEHelper {
    protected SecurityContext securityContext;
    protected PolicyRegistration policyRegistration;

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext sc) {
        if (sc == null) {
            throw new IllegalArgumentException("sc is null");
        }
        this.securityContext = sc;
    }

    public PolicyRegistration getPolicyRegistration() {
        return this.policyRegistration;
    }

    public void setPolicyRegistration(PolicyRegistration policyRegistration) {
        this.policyRegistration = policyRegistration;
    }

    public Principal getCallerPrincipal() {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Principal caller = null;
                if (AbstractJavaEEHelper.this.securityContext != null && (caller = AbstractJavaEEHelper.this.securityContext.getIncomingRunAs()) == null) {
                    caller = AbstractJavaEEHelper.this.securityContext.getUtil().getUserPrincipal();
                }
                return caller;
            }
        });
    }

    protected void authorizationAudit(String level, Resource resource, Exception e) {
        if (this.securityContext.getAuditManager() == null) {
            return;
        }
        String exceptionMessage = e != null ? e.getLocalizedMessage() : "";
        HashMap<String, Object> auditContextMap = new HashMap<String, Object>();
        auditContextMap.putAll(resource.getMap());
        auditContextMap.put("Resource:", resource.toString());
        auditContextMap.put("Exception:", exceptionMessage);
        this.audit(level, auditContextMap, null);
    }

    protected void audit(String level, Map<String, Object> contextMap, Exception e) {
        AuditManager am = this.securityContext.getAuditManager();
        if (am == null) {
            return;
        }
        contextMap.put("Source", this.getClass().getName());
        AuditEvent ae = new AuditEvent(level, contextMap, e);
        am.audit(ae);
    }

    protected Map<String, Object> getContextMap(Principal principal, String methodName) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        cmap.put("method", methodName);
        return cmap;
    }
}

