/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.otp;

import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.TimeZone;
import org.jboss.security.otp.TimeBasedOTP;

public class TimeBasedOTPUtil {
    private static long TIME_INTERVAL = 30000L;

    public static boolean validate(String submittedOTP, byte[] secret, int numDigits) throws GeneralSecurityException {
        long timeInMilis;
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar currentDateTime = Calendar.getInstance(utc);
        String generatedTOTP = TimeBasedOTP.generateTOTP(new String(secret), numDigits);
        boolean result = generatedTOTP.equals(submittedOTP);
        if (!result) {
            timeInMilis = currentDateTime.getTimeInMillis();
            generatedTOTP = TimeBasedOTP.generateTOTP(new String(secret), "" + (timeInMilis -= TIME_INTERVAL), numDigits);
            result = generatedTOTP.equals(submittedOTP);
        }
        if (!result) {
            timeInMilis = currentDateTime.getTimeInMillis();
            generatedTOTP = TimeBasedOTP.generateTOTP(new String(secret), "" + (timeInMilis += TIME_INTERVAL), numDigits);
            result = generatedTOTP.equals(submittedOTP);
        }
        return result;
    }

    public static boolean validate256(String submittedOTP, byte[] secret, int numDigits) throws GeneralSecurityException {
        long timeInMilis;
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar currentDateTime = Calendar.getInstance(utc);
        String generatedTOTP = TimeBasedOTP.generateTOTP256(new String(secret), numDigits);
        boolean result = generatedTOTP.equals(submittedOTP);
        if (!result) {
            timeInMilis = currentDateTime.getTimeInMillis();
            generatedTOTP = TimeBasedOTP.generateTOTP256(new String(secret), "" + (timeInMilis -= TIME_INTERVAL), numDigits);
            result = generatedTOTP.equals(submittedOTP);
        }
        if (!result) {
            timeInMilis = currentDateTime.getTimeInMillis();
            generatedTOTP = TimeBasedOTP.generateTOTP256(new String(secret), "" + (timeInMilis += TIME_INTERVAL), numDigits);
            result = generatedTOTP.equals(submittedOTP);
        }
        return result;
    }

    public static boolean validate512(String submittedOTP, byte[] secret, int numDigits) throws GeneralSecurityException {
        long timeInMilis;
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar currentDateTime = Calendar.getInstance(utc);
        String generatedTOTP = TimeBasedOTP.generateTOTP512(new String(secret), numDigits);
        boolean result = generatedTOTP.equals(submittedOTP);
        if (!result) {
            timeInMilis = currentDateTime.getTimeInMillis();
            generatedTOTP = TimeBasedOTP.generateTOTP512(new String(secret), "" + (timeInMilis -= TIME_INTERVAL), numDigits);
            result = generatedTOTP.equals(submittedOTP);
        }
        if (!result) {
            timeInMilis = currentDateTime.getTimeInMillis();
            generatedTOTP = TimeBasedOTP.generateTOTP512(new String(secret), "" + (timeInMilis += TIME_INTERVAL), numDigits);
            result = generatedTOTP.equals(submittedOTP);
        }
        return result;
    }
}

