/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.saml.extensions;

import jakarta.servlet.http.HttpSession;
import java.io.InputStream;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.AssertionExpiredException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.SerializablePrincipal;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2AuthenticationHandler;
import org.picketlink.identity.federation.web.interfaces.IRoleValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2ExtendedAuthenticationHandler
extends SAML2AuthenticationHandler {
    private final SPExtendedAuthenticationHandler sp = new SPExtendedAuthenticationHandler();

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            super.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    private class SPExtendedAuthenticationHandler {
        private SPExtendedAuthenticationHandler() {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            ResponseType responseType = (ResponseType)request.getSAML2Object();
            SAML2ExtendedAuthenticationHandler.this.checkDestination(responseType.getDestination(), this.getSPConfiguration().getServiceURL());
            List assertions = responseType.getAssertions();
            if (assertions.size() == 0) {
                throw logger.samlHandlerNoAssertionFromIDP();
            }
            PrivateKey privateKey = (PrivateKey)request.getOptions().get("DECRYPTING_KEY");
            EncryptedAssertionType assertion = ((ResponseType.RTChoiceType)assertions.get(0)).getEncryptedAssertion();
            if (assertion instanceof EncryptedAssertionType) {
                responseType = this.decryptAssertion(responseType, privateKey);
                assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
            }
            if (assertion == null) {
                assertion = ((ResponseType.RTChoiceType)assertions.get(0)).getAssertion();
            }
            request.addOption("ASSERTION", (Object)assertion);
            Principal userPrincipal = this.handleSAMLResponse(responseType, response);
            if (userPrincipal == null) {
                response.setError(403, "User Principal not determined: Forbidden");
            } else {
                HttpSession session = httpContext.getRequest().getSession(false);
                session.setAttribute("picketlink.principal", (Object)userPrincipal);
                Document responseDocument = request.getRequestDocument();
                Element assertionElement = DocumentUtil.getChildElement((Element)responseDocument.getDocumentElement(), (QName)new QName(JBossSAMLConstants.ASSERTION.get()));
                if (assertionElement != null) {
                    try {
                        Document assertionDocument = DocumentUtil.createDocument();
                        Node clonedAssertion = assertionElement.cloneNode(true);
                        assertionDocument.adoptNode(clonedAssertion);
                        assertionDocument.appendChild(clonedAssertion);
                        String assertionAttributeName = (String)SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("ASSERTION_SESSION_ATTRIBUTE_NAME");
                        if (assertionAttributeName != null) {
                            session.setAttribute(assertionAttributeName, (Object)assertionDocument);
                        }
                        session.setAttribute("ASSERTION_SESSION_ATTRIBUTE_NAME", (Object)assertionDocument);
                    }
                    catch (ConfigurationException e) {
                        throw new ProcessingException("Could not store assertion document into session.", (Throwable)e);
                    }
                }
            }
        }

        private ResponseType decryptAssertion(ResponseType responseType, PrivateKey privateKey) throws ProcessingException {
            if (privateKey == null) {
                throw logger.nullArgumentError("privateKey");
            }
            SAML2Response saml2Response = new SAML2Response();
            try {
                Document doc = saml2Response.convert((StatusResponseType)responseType);
                Element enc = DocumentUtil.getElement((Document)doc, (QName)new QName(JBossSAMLConstants.ENCRYPTED_ASSERTION.get()));
                if (enc == null) {
                    throw logger.samlHandlerNullEncryptedAssertion();
                }
                String oldID = enc.getAttribute(JBossSAMLConstants.ID.get());
                Document newDoc = DocumentUtil.createDocument();
                Node importedNode = newDoc.importNode(enc, true);
                newDoc.appendChild(importedNode);
                Element decryptedDocumentElement = XMLEncryptionUtil.decryptElementInDocument((Document)newDoc, (PrivateKey)privateKey);
                SAMLParser parser = new SAMLParser();
                JAXPValidationUtil.checkSchemaValidation((Node)decryptedDocumentElement);
                AssertionType assertion = (AssertionType)parser.parse(StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)decryptedDocumentElement)));
                responseType.replaceAssertion(oldID, new ResponseType.RTChoiceType(assertion));
                return responseType;
            }
            catch (Exception e) {
                throw logger.processingError((Throwable)e);
            }
        }

        private Principal handleSAMLResponse(ResponseType responseType, SAML2HandlerResponse response) throws ProcessingException {
            boolean expiredAssertion;
            if (responseType == null) {
                throw logger.nullArgumentError("response type");
            }
            StatusType statusType = responseType.getStatus();
            if (statusType == null) {
                throw logger.nullArgumentError("Status Type from the IDP");
            }
            String statusValue = statusType.getStatusCode().getValue().toASCIIString();
            if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
                throw logger.samlHandlerIDPAuthenticationFailedError();
            }
            List assertions = responseType.getAssertions();
            if (assertions.size() == 0) {
                throw logger.samlHandlerNoAssertionFromIDP();
            }
            AssertionType assertion = ((ResponseType.RTChoiceType)assertions.get(0)).getAssertion();
            try {
                String skew = (String)SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("CLOCK_SKEW_MILIS");
                if (StringUtil.isNotNull((String)skew)) {
                    long skewMilis = Long.parseLong(skew);
                    expiredAssertion = AssertionUtil.hasExpired((AssertionType)assertion, (long)skewMilis);
                } else {
                    expiredAssertion = AssertionUtil.hasExpired((AssertionType)assertion);
                }
            }
            catch (ConfigurationException e) {
                throw new ProcessingException((Throwable)e);
            }
            if (expiredAssertion) {
                AssertionExpiredException aee = new AssertionExpiredException();
                aee.setId(assertion.getID());
                throw logger.assertionExpiredError(aee);
            }
            if (!AssertionUtil.isAudience((AssertionType)assertion, (SPType)this.getSPConfiguration())) {
                throw logger.samlAssertionWrongAudience(this.getSPConfiguration().getServiceURL());
            }
            SubjectType subject = assertion.getSubject();
            if (subject == null) {
                throw logger.nullValueError("Subject in the assertion");
            }
            SubjectType.STSubType subType = subject.getSubType();
            if (subType == null) {
                throw logger.nullValueError("Unable to find subtype via subject");
            }
            NameIDType nameID = (NameIDType)subType.getBaseID();
            if (nameID == null) {
                throw logger.nullValueError("Unable to find username via subject");
            }
            String userName = nameID.getValue();
            if (!Boolean.parseBoolean((String)SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("USE_NAMEID"))) {
                Set statements = assertion.getStatements();
                for (StatementAbstractType statement : statements) {
                    if (!(statement instanceof AttributeStatementType)) continue;
                    AttributeStatementType attributeStatement = (AttributeStatementType)statement;
                    List attList = attributeStatement.getAttributes();
                    for (AttributeStatementType.ASTChoiceType obj : attList) {
                        AttributeType attr = obj.getAttribute();
                        if ((attr.getFriendlyName() == null || !attr.getFriendlyName().equals(SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("SUBJECT_ATTRIBUTE"))) && (attr.getName() == null || !attr.getName().equals(SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("SUBJECT_ATTRIBUTE"))) || attr.getAttributeValue() == null) continue;
                        userName = (String)attr.getAttributeValue().get(0);
                    }
                }
            }
            ArrayList<String> roles = new ArrayList<String>();
            Set statements = assertion.getStatements();
            for (StatementAbstractType statement : statements) {
                if (!(statement instanceof AttributeStatementType)) continue;
                AttributeStatementType attributeStatement = (AttributeStatementType)statement;
                roles.addAll(this.getRoles(attributeStatement));
            }
            response.setRoles(roles);
            SerializablePrincipal principal = new SerializablePrincipal(userName);
            if (SAML2ExtendedAuthenticationHandler.this.handlerChainConfig.getParameter("ROLE_VALIDATOR_IGNORE") == null) {
                IRoleValidator roleValidator = (IRoleValidator)SAML2ExtendedAuthenticationHandler.this.handlerChainConfig.getParameter("ROLE_VALIDATOR");
                if (roleValidator == null) {
                    throw logger.nullValueError("Role Validator");
                }
                boolean validRole = roleValidator.userInRole((Principal)principal, roles);
                if (!validRole) {
                    logger.trace("Invalid role: " + String.valueOf(roles));
                    principal = null;
                }
            }
            return principal;
        }

        private List<String> getRoles(AttributeStatementType attributeStatement) {
            String roleKey;
            String val;
            ArrayList<String> roles = new ArrayList<String>();
            if (SAML2ExtendedAuthenticationHandler.this.handlerConfig.containsKey("DISABLE_ROLE_PICKING") && StringUtil.isNotNull((String)(val = (String)SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("DISABLE_ROLE_PICKING"))) && "true".equalsIgnoreCase(val)) {
                return roles;
            }
            ArrayList roleKeys = new ArrayList();
            if (SAML2ExtendedAuthenticationHandler.this.handlerConfig.containsKey("ROLE_KEY") && StringUtil.isNotNull((String)(roleKey = (String)SAML2ExtendedAuthenticationHandler.this.handlerConfig.getParameter("ROLE_KEY")))) {
                roleKeys.addAll(StringUtil.tokenize((String)roleKey));
            }
            List attList = attributeStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType obj : attList) {
                List attributeValues;
                AttributeType attr = obj.getAttribute();
                if (roleKeys.size() > 0 && !roleKeys.contains(attr.getName()) || (attributeValues = attr.getAttributeValue()) == null) continue;
                for (Object attrValue : attributeValues) {
                    if (attrValue instanceof String) {
                        roles.add((String)attrValue);
                        continue;
                    }
                    if (attrValue instanceof Node) {
                        Node roleNode = (Node)attrValue;
                        roles.add(roleNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    throw logger.unsupportedRoleType(attrValue);
                }
            }
            return roles;
        }

        private SPType getSPConfiguration() {
            SPType spConfiguration = (SPType)SAML2ExtendedAuthenticationHandler.this.handlerChainConfig.getParameter("CONFIGURATION");
            if (spConfiguration == null) {
                throw logger.samlHandlerServiceProviderConfigNotFound();
            }
            return spConfiguration;
        }
    }
}

