/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.Calendar;
import java.util.TimeZone;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.AbstractNotificationPlugin;
import org.exoplatform.task.integration.notification.NotificationUtils;

public class TaskDueDatePlugin
extends AbstractNotificationPlugin {
    public static final String ID = "TaskDueDatePlugin";

    public TaskDueDatePlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    @Override
    public NotificationInfo makeNotification(NotificationContext ctx) {
        NotificationInfo info = super.makeNotification(ctx);
        TaskDto task = (TaskDto)ctx.value(NotificationUtils.TASK);
        Calendar grpDueDate = Calendar.getInstance(TimeZone.getTimeZone("GMT0"));
        grpDueDate.setTime(task.getDueDate());
        grpDueDate.set(11, 0);
        grpDueDate.set(12, 0);
        grpDueDate.set(13, 0);
        grpDueDate.set(14, 0);
        String actId = info.getValueOwnerParameter("activityId");
        info.with("activityId", actId + String.valueOf(grpDueDate.getTimeInMillis()));
        info.with("dueDate", String.valueOf(task.getDueDate().getTime()));
        return info;
    }

    public boolean isValid(NotificationContext ctx) {
        TaskDto task = (TaskDto)ctx.value(NotificationUtils.TASK);
        return task.getDueDate() != null && (task.getAssignee() != null && !task.getAssignee().isEmpty() || task.getCoworker() != null && task.getCoworker().size() > 0 || task.getWatcher() != null && task.getWatcher().size() > 0);
    }
}

