/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.service.TaskBuilder;
import org.exoplatform.task.service.TaskParserPlugin;

public class TaskPriorityParserPlugin
implements TaskParserPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(TaskPriorityParserPlugin.class);

    @Override
    public String parse(String input, TaskBuilder builder) {
        Pattern p = Pattern.compile("(\\s)(!)([a-zA-Z]+)");
        Matcher m = p.matcher(input);
        while (m.find()) {
            String priority = m.group(3);
            try {
                builder.withPriority(Priority.valueOf(priority.toUpperCase()));
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"Issue during parsing task priority: ", (Throwable)ex);
            }
        }
        String in = input.replaceAll("\\s![a-zA-Z]+\\s*", " ").trim();
        return in;
    }
}

