/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.calendar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.calendar.model.Calendar;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.storage.CalendarDAO;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.UserUtil;

public class TasksCalendarDAOImpl
implements CalendarDAO {
    private static final String NAME_SUFFIX = " Tasks";
    private ProjectService projectService;
    private TaskService taskService;
    private static final Log LOG = ExoLogger.getExoLogger(TasksCalendarDAOImpl.class);
    public final Calendar DF_CALENDAR = this.newInstance();

    public TasksCalendarDAOImpl(ProjectService projectService, TaskService taskService) {
        this.DF_CALENDAR.setId(String.valueOf(-2));
        this.DF_CALENDAR.setHasChildren(true);
        this.DF_CALENDAR.setName("Tasks");
        this.projectService = projectService;
        this.taskService = taskService;
    }

    public Calendar getById(String id) {
        try {
            Calendar cal = this.newInstance();
            if (this.DF_CALENDAR.getId().equals(id)) {
                return this.DF_CALENDAR;
            }
            Project project = this.projectService.getProject(Long.valueOf(id));
            if (project.isCalendarIntegrated()) {
                return this.buildCalendar(cal, project);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while loading calendar by ID", (Throwable)ex);
        }
        return null;
    }

    public List<Calendar> findCalendars(CalendarQuery query) {
        Identity identity = query.getIdentity();
        List permissions = UserUtil.getMemberships((Identity)identity);
        ListAccess tmp = this.projectService.findProjects(permissions, null, null);
        List<Object> projects = new LinkedList();
        try {
            projects = Arrays.asList(tmp.load(0, -1));
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't load project list", (Throwable)ex);
        }
        projects = ProjectUtil.flattenTree(projects, (ProjectService)this.projectService);
        if (query.getExclusions() != null) {
            projects = this.filterExclusions(projects, query.getExclusions());
        }
        LinkedList<Calendar> calendars = new LinkedList<Calendar>();
        if (query.getExclusions() == null || !Arrays.asList(query.getExclusions()).contains(this.DF_CALENDAR.getId())) {
            calendars.add(this.DF_CALENDAR);
        }
        for (Project project : projects) {
            if (!project.isCalendarIntegrated()) continue;
            Calendar cal = this.newInstance();
            calendars.add(this.buildCalendar(cal, project));
        }
        return calendars;
    }

    private List<Project> filterExclusions(List<Project> projects, String[] excludesId) {
        for (String id : excludesId) {
            Iterator<Project> iter = projects.iterator();
            while (iter.hasNext()) {
                Project p = iter.next();
                if (p.getId() != Long.valueOf(id).longValue()) continue;
                iter.remove();
            }
        }
        return projects;
    }

    public Calendar save(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Calendar update(Calendar cal) {
        throw new UnsupportedOperationException();
    }

    public Calendar remove(String id) {
        throw new UnsupportedOperationException();
    }

    public Calendar newInstance() {
        Calendar c = new Calendar("");
        c.setDS("tasks");
        return c;
    }

    private Calendar buildCalendar(Calendar calendar, Project project) {
        if (project == null || calendar == null) {
            return null;
        }
        if (project.getColor() != null) {
            calendar.setCalendarColor(project.getColor());
        }
        calendar.setDescription(project.getDescription());
        calendar.setEditPermission(null);
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProjectIds(Arrays.asList(project.getId()));
        ListAccess listTask = this.taskService.findTasks(taskQuery);
        calendar.setHasChildren(ListUtil.getSize((ListAccess)listTask) > 0);
        calendar.setId(String.valueOf(project.getId()));
        calendar.setName(project.getName() + NAME_SUFFIX);
        HashSet permissions = new HashSet();
        if (project.getManager() != null) {
            permissions.addAll(project.getManager());
        }
        if (project.getParticipator() != null) {
            permissions.addAll(project.getParticipator());
        }
        calendar.setViewPermission(permissions.toArray(new String[permissions.size()]));
        return calendar;
    }
}

