/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.util.regex.Pattern;
import org.exoplatform.commons.utils.HTMLEntityEncoder;

public class StringUtil {
    public static final String ORDERBY_DATE = "date";
    public static final String ORDERBY_TITLE = "title";
    public static final String ORDERBY_RELEVANCY = "relevancy";
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    public static final Pattern FUZZY = Pattern.compile(".[~][0]([\\.][0-9])");

    public static String highlight(String text, String keyword, String before, String after) {
        if (text == null || text.isEmpty() || keyword == null || keyword.isEmpty()) {
            return text;
        }
        String lowerText = text.toLowerCase();
        String lowerKeyword = keyword.toLowerCase();
        StringBuilder result = new StringBuilder();
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        int length = keyword.length();
        int fromIndex = 0;
        int index = lowerText.indexOf(lowerKeyword, fromIndex);
        while (index != -1) {
            result.append(encoder.encode(text.substring(fromIndex, index)));
            result.append(before);
            result.append(encoder.encode(text.substring(index, index + length)));
            result.append(after);
            fromIndex = index + length;
            index = lowerText.indexOf(lowerKeyword, fromIndex);
        }
        result.append(encoder.encode(text.substring(fromIndex)));
        return result.toString();
    }
}

