/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.lang.reflect.Array;
import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.task.dao.jpa.DAOHandlerJPAImpl;

public class JPAQueryListAccess<E>
implements ListAccess<E> {
    private final Class<E> clazz;
    private final TypedQuery<Long> countQuery;
    private final TypedQuery<E> selectQuery;
    private long size = -1L;

    public JPAQueryListAccess(Class<E> clazz, TypedQuery<Long> countQuery, TypedQuery<E> selectQuery) {
        this.clazz = clazz;
        this.countQuery = countQuery;
        this.selectQuery = selectQuery;
    }

    public E[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (length > 0) {
            this.selectQuery.setFirstResult(index).setMaxResults(length);
        } else {
            this.selectQuery.setFirstResult(0).setMaxResults(Integer.MAX_VALUE);
        }
        List list = this.selectQuery.getResultList();
        Object[] e = (Object[])Array.newInstance(this.clazz, list.size());
        for (int i = 0; i < e.length; ++i) {
            Object clone = DAOHandlerJPAImpl.clone(list.get(i));
            e[i] = clone != null ? clone : list.get(i);
        }
        return e;
    }

    public int getSize() throws Exception {
        if (this.size == -1L) {
            this.size = (Long)this.countQuery.getSingleResult();
        }
        return (int)this.size;
    }
}

