/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dao.condition.SingleCondition;
import org.exoplatform.task.dao.jpa.CommonJPADAO;
import org.exoplatform.task.domain.Project;

public class ProjectDAOImpl
extends CommonJPADAO<Project, Long>
implements ProjectHandler {
    private static final Logger LOG = Logger.getLogger("ProjectDAOImpl");

    public Project update(Project entity) {
        return (Project)this.cloneEntity(super.update((Object)entity));
    }

    public void delete(Project entity) {
        Project p = (Project)this.getEntityManager().find(Project.class, (Object)entity.getId());
        if (p != null) {
            super.delete((Object)p);
        }
    }

    @Override
    public Project removeProject(long projectId, boolean deleteChild) {
        Project p = (Project)this.getEntityManager().find(Project.class, (Object)projectId);
        if (p == null) {
            return null;
        }
        if (!deleteChild && p.getChildren() != null) {
            for (Project pj : p.getChildren()) {
                pj.setParent(p.getParent());
                this.getEntityManager().persist((Object)pj);
            }
            p.getChildren().clear();
        }
        super.delete((Object)p);
        return p;
    }

    @Override
    public ListAccess<Project> findSubProjects(Project project) {
        ProjectQuery query = new ProjectQuery();
        if (project != null) {
            query.setParent(project.getId());
        } else {
            query.setParent(null);
        }
        return this.findProjects(query);
    }

    @Override
    public ListAccess<Project> findAllByMembershipsAndKeyword(List<String> memberships, String keyword, OrderBy order) {
        ProjectQuery query = new ProjectQuery();
        query.setMembership(memberships);
        query.setKeyword(keyword);
        if (order != null) {
            query.setOrderBy(Arrays.asList(order));
        }
        return this.findProjects(query);
    }

    @Override
    public ListAccess<Project> findProjects(ProjectQuery query) {
        return this.findEntities(query, Project.class);
    }

    @Override
    protected Path buildPath(SingleCondition condition, Root<Project> root) {
        String field = condition.getField();
        if ("manager".equals(field) || "participator".equals(field)) {
            return root.join(field, JoinType.LEFT);
        }
        return super.buildPath(condition, root);
    }

    @Override
    public <T> List<T> selectProjectField(ProjectQuery query, String fieldName) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery();
        Root project = q.from(Project.class);
        Predicate predicate = this.buildQuery(query.getCondition(), project, cb, q);
        if (predicate != null) {
            q.where((Expression)predicate);
        }
        q.select((Selection)project.join(fieldName)).distinct(true);
        TypedQuery selectQuery = em.createQuery(q);
        return this.cloneEntities(selectQuery.getResultList());
    }
}

