/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.TaskSearchResult;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ResourceUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.task.util.UserUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;

public class TaskSearchConnector
extends SearchServiceConnector {
    private static final int MAX_EXCERPT_LENGTH = 430;
    public static final String DUE_FOR = "Due for: ";
    private TaskService taskService;
    private WebAppController controller;
    private UserService userService;

    public TaskSearchConnector(InitParams initParams, TaskService taskService, WebAppController controller, UserService userService) {
        super(initParams);
        this.taskService = taskService;
        this.controller = controller;
        this.userService = userService;
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        Task[] tasks;
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (query == null || query.trim().isEmpty()) {
            return result;
        }
        query = StringUtil.FUZZY.matcher(query.trim()).replaceAll("");
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        List permissions = UserUtil.getMemberships((Identity)currentUser);
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setKeyword(query, true);
        taskQuery.setAccessible(currentUser);
        OrderBy orderBy = this.buildOrderBy(sort, order);
        if (orderBy != null) {
            taskQuery.setOrderBy(Arrays.asList(orderBy));
        }
        SimpleDateFormat df = new SimpleDateFormat("EEEEE, MMMMMMMM d, yyyy");
        df.setTimeZone(this.userService.getUserTimezone(currentUser.getUserId()));
        for (Task t : tasks = (Task[])ListUtil.load((ListAccess)this.taskService.findTasks(taskQuery), (int)0, (int)-1)) {
            result.add(this.buildResult(t, df));
        }
        return ResourceUtil.subList(result, (int)offset, (int)limit);
    }

    private SearchResult buildResult(Task t, SimpleDateFormat df) {
        String url = this.buildUrl(t);
        String imageUrl = this.buildImageUrl(t);
        String excerpt = this.buildExcerpt(t);
        String projectName = t.getStatus() != null ? t.getStatus().getProject().getName() : null;
        String priority = t.getPriority() != null ? t.getPriority().name() : null;
        String dueDate = t.getDueDate() != null ? DUE_FOR + df.format(t.getDueDate()) : null;
        return new TaskSearchResult(url, t.getTitle(), excerpt, imageUrl, projectName, priority, dueDate, t.isCompleted(), t.getCreatedTime().getTime(), 0L);
    }

    private String buildExcerpt(Task t) {
        String description = t.getDescription();
        if (description != null) {
            if (description.length() > 430) {
                return description.substring(0, 430) + "...";
            }
            return description;
        }
        return null;
    }

    private String buildImageUrl(Task t) {
        return null;
    }

    private String buildUrl(Task t) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return TaskUtil.buildTaskURL((Task)t, (SiteKey)SiteKey.portal((String)"intranet"), (ExoContainer)container, (Router)this.controller.getRouter());
    }

    private OrderBy buildOrderBy(String sort, String order) {
        String orderBy = null;
        if ("date".equals(sort) || "relevancy".equals(sort)) {
            orderBy = "createdTime";
        } else if ("title".equals(sort)) {
            orderBy = "title";
        }
        if (orderBy != null) {
            if ("asc".equals(order)) {
                return new OrderBy.ASC(orderBy);
            }
            return new OrderBy.DESC(orderBy);
        }
        return null;
    }
}

