/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.platform;

import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/create/UICreateTask.gtmpl", events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICreateTask
extends UIForm {
    private static Log log = ExoLogger.getLogger(UICreateTask.class);
    public static String TITLE = "title";
    private final TaskParser taskParser;
    private final TaskService taskService;
    private final UserService userService;
    private final WebAppController webAppController;
    protected String errorMessage = null;

    public UICreateTask() {
        UIFormStringInput input = new UIFormStringInput(TITLE, TITLE, null);
        input.setHTMLAttribute("class", "span3");
        this.addUIFormInput((UIFormInput)input);
        this.taskParser = (TaskParser)this.getApplicationComponent(TaskParser.class);
        this.taskService = (TaskService)this.getApplicationComponent(TaskService.class);
        this.userService = (UserService)this.getApplicationComponent(UserService.class);
        this.webAppController = (WebAppController)this.getApplicationComponent(WebAppController.class);
    }

    public String getError() {
        return this.errorMessage;
    }

    public static String getResourceBundle(String key, String defaultValue) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            log.warn((Object)("Can not find the resource for key: " + key));
            return defaultValue;
        }
    }

    public static class CancelActionListener
    extends EventListener<UICreateTask> {
        public void execute(Event<UICreateTask> event) throws Exception {
            UICreateTask uisource = (UICreateTask)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            Event cancelEvent = uisource.getParent().createEvent("Cancel", Event.Phase.DECODE, ctx);
            if (cancelEvent != null) {
                cancelEvent.broadcast();
            }
        }
    }

    public static class AddActionListener
    extends EventListener<UICreateTask> {
        public void execute(Event<UICreateTask> event) throws Exception {
            UICreateTask ui = (UICreateTask)((Object)event.getSource());
            ui.errorMessage = null;
            UIFormStringInput input = ui.getUIStringInput(TITLE);
            String title = (String)input.getValue();
            if (title == null || title.trim().isEmpty()) {
                ui.errorMessage = UICreateTask.getResourceBundle(ui.getId() + ".msg.titleRequired", "Task title is required");
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)ui);
                return;
            }
            String username = event.getRequestContext().getRemoteUser();
            TimeZone tz = ui.userService.getUserTimezone(username);
            Task task = ui.taskParser.parse(title, new ParserContext(tz));
            task.setCreatedBy(username);
            task.setCreatedTime(new Date());
            task = ui.taskService.createTask(task);
            Event cancelEvent = ui.getParent().createEvent("Cancel", Event.Phase.PROCESS, event.getRequestContext());
            if (cancelEvent != null) {
                cancelEvent.broadcast();
            }
            event.getRequestContext().getUserPortal();
            String taskURL = TaskUtil.buildTaskURL((Task)task, (SiteKey)SiteKey.portal((String)"intranet"), (ExoContainer)ExoContainerContext.getCurrentContainer(), (Router)ui.webAppController.getRouter());
            String defaultMsg = "The task has been added";
            String message = UICreateTask.getResourceBundle(ui.getId() + ".msg.add-successfully", defaultMsg);
            event.getRequestContext().getJavascriptManager().require("SHARED/navigation-toolbar", "toolbarnav").addScripts("toolbarnav.UIPortalNavigation.cancelNextClick('UICreateList','UICreatePlatformToolBarPortlet','" + StringEscapeUtils.escapeJavaScript((String)message) + "', '" + taskURL + "');");
        }
    }
}

