/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;

public class ActivityTaskProcessor
extends BaseActivityProcessorPlugin {
    private final TaskService taskService;
    private final EntityManagerService entityManagerService;
    private final WebAppController webAppController;

    public ActivityTaskProcessor(InitParams params, WebAppController controller, TaskService taskServ, EntityManagerService entityManagerService) {
        super(params);
        this.entityManagerService = entityManagerService;
        this.taskService = taskServ;
        this.webAppController = controller;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            activity.setTitle(this.substituteTask(activity.getTitle(), activity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substituteTask(String message, ExoSocialActivity activity) {
        if (message == null) {
            return null;
        }
        int idx = message.indexOf("++");
        if (idx >= 0) {
            try {
                RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
                Task task = this.taskService.findTaskByActivityId(activity.getId());
                if (task != null) {
                    String string = ActivityTaskProcessor.substituteTask(task, message, this.webAppController.getRouter());
                    return string;
                }
                String string = ActivityTaskProcessor.encode(message);
                return string;
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        return message;
    }

    public static String encode(String message) {
        if (message != null && !message.isEmpty()) {
            message = message.replaceAll("@", "{@}");
        }
        return message;
    }

    public static String decode(String message) {
        if (message != null && !message.isEmpty()) {
            message = message.replaceAll("\\{@\\}", "@");
        }
        return message;
    }

    static String substituteTask(Task task, String title, Router router) {
        if (task == null || title == null) {
            return title;
        }
        int idx = title.indexOf("++");
        if (idx == -1) {
            return title;
        }
        int breakIdx = title.indexOf("<br", idx);
        StringBuilder builder = new StringBuilder(title);
        String taskURL = TaskUtil.buildTaskURL((Task)task, (SiteKey)CommonsUtils.getCurrentSite(), (ExoContainer)ExoContainerContext.getCurrentContainer(), (Router)router);
        String url = " <a href='" + taskURL + "'>";
        builder.insert(idx, url);
        if (breakIdx > 0) {
            builder.insert(breakIdx += url.length(), "</a>");
        } else {
            builder.append("</a>");
        }
        return builder.toString();
    }
}

