/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;

public abstract class AbstractNotificationPlugin
extends BaseNotificationPlugin {
    public AbstractNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Task task = (Task)ctx.value(NotificationUtils.TASK);
        String creator = (String)ctx.value(NotificationUtils.CREATOR);
        String projectName = "";
        String projectId = "";
        Project project = null;
        if (task.getStatus() != null) {
            project = task.getStatus().getProject();
            projectName = project.getName();
            projectId = String.valueOf(project.getId());
        }
        StringBuilder activityId = new StringBuilder(projectId);
        activityId.append("-").append(creator);
        ExoContainer container = this.getContainer();
        WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
        RequestLifeCycle.begin((ExoContainer)container);
        String taskUrl = this.buildTaskUrl(task, container, controller);
        String projectUrl = this.buildProjectUrl(project, container, controller);
        Set<String> receivers = this.getReceiver(task, ctx);
        RequestLifeCycle.end();
        return NotificationInfo.instance().to(new LinkedList<String>(receivers)).with("taskName", task.getTitle()).with("taskDescription", task.getDescription()).with(NotificationUtils.CREATOR.getKey(), creator).with("projectName", projectName).with("activityId", activityId.toString()).with("taskUrl", taskUrl).with("projectUrl", projectUrl).key(this.getKey()).end();
    }

    private ExoContainer getContainer() {
        String containerName = PortalContainer.getCurrentPortalContainerName();
        PortalContainer container = RootContainer.getInstance().getPortalContainer(containerName);
        return container;
    }

    private String buildProjectUrl(Project project, ExoContainer container, WebAppController controller) {
        return CommonsUtils.getCurrentDomain() + ProjectUtil.buildProjectURL((Project)project, (SiteKey)CommonsUtils.getCurrentSite(), (ExoContainer)container, (Router)controller.getRouter());
    }

    protected Set<String> getReceiver(Task task, NotificationContext ctx) {
        HashSet<String> receivers = new HashSet<String>();
        if (task.getAssignee() != null && !task.getAssignee().isEmpty()) {
            receivers.add(task.getAssignee());
        }
        if (task.getCoworker() != null && task.getCoworker().size() > 0) {
            receivers.addAll(task.getCoworker());
        }
        if (ctx != null) {
            receivers.remove(ctx.value(NotificationUtils.CREATOR));
        }
        return receivers;
    }

    private String buildTaskUrl(Task t, ExoContainer container, WebAppController controller) {
        return CommonsUtils.getCurrentDomain() + TaskUtil.buildTaskURL((Task)t, (SiteKey)CommonsUtils.getCurrentSite(), (ExoContainer)container, (Router)controller.getRouter());
    }
}

