/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.task.dao.Query;
import org.exoplatform.task.dao.condition.Condition;
import org.exoplatform.task.dao.condition.Conditions;
import org.exoplatform.task.dao.condition.SingleCondition;

public class ProjectQuery
extends Query {
    public ProjectQuery setMembership(List<String> memberships) {
        if (memberships != null) {
            this.add(Conditions.or(Conditions.in("manager", memberships), Conditions.in("participator", memberships)));
        }
        return this;
    }

    public ProjectQuery setManager(List<String> managers) {
        if (managers != null) {
            this.add(Conditions.in("manager", managers));
        }
        return this;
    }

    public ProjectQuery setParticipator(List<String> participators) {
        if (participators != null) {
            this.add(Conditions.in("participator", participators));
        }
        return this;
    }

    public ProjectQuery setKeyword(String keyword) {
        if (keyword != null && !keyword.trim().isEmpty()) {
            LinkedList<SingleCondition<String>> keys = new LinkedList<SingleCondition<String>>();
            for (String k : keyword.split(" ")) {
                if ((k = k.trim()).isEmpty()) continue;
                k = "%" + k.toLowerCase() + "%";
                keys.add(Conditions.like("name", k));
            }
            this.add(Conditions.or(keys.toArray(new Condition[keys.size()])));
        }
        return this;
    }

    public ProjectQuery setParent(Long parentId) {
        if (parentId != null && parentId > 0L) {
            this.add(Conditions.eq("parent", parentId));
        } else {
            this.add(Conditions.or(Conditions.eq("parent", 0L), Conditions.isNull("parent")));
        }
        return this;
    }
}

