/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceApplicationConfigPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class SpaceTaskAppInstaller
implements Startable {
    private String prevApp = "SpaceActivityStreamPortlet";
    private String taskPortletName = "TaskManagementApplication";
    private String taskAppName = "task-management";
    private String taskUri = "tasks";
    private static final Log log = ExoLogger.getExoLogger(SpaceTaskAppInstaller.class);

    public SpaceTaskAppInstaller(InitParams params) {
        if (params != null) {
            this.config(params, "prevApp");
            this.config(params, "taskPortletName");
            this.config(params, "taskAppName");
            this.config(params, "taskUri");
        }
    }

    public void start() {
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        SpaceApplicationConfigPlugin plugin = spaceService.getSpaceApplicationConfigPlugin();
        List apps = plugin.getSpaceApplicationList();
        if (!this.isTaskExists(apps)) {
            int idx = this.getTaskIndex(apps);
            SpaceApplicationConfigPlugin.SpaceApplication taskApp = new SpaceApplicationConfigPlugin.SpaceApplication();
            taskApp.setPortletApp(this.taskAppName);
            taskApp.setPortletName(this.taskPortletName);
            taskApp.setAppTitle("abcd");
            taskApp.setUri(this.taskUri);
            taskApp.isRemovable(true);
            apps.add(idx, taskApp);
            plugin.setSpaceApplicationList(apps);
        }
    }

    private void config(InitParams params, String name) {
        ValueParam p = params.getValueParam(name);
        if (p != null) {
            try {
                this.getClass().getDeclaredField(name).set(this, p.getValue());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private int getTaskIndex(List<SpaceApplicationConfigPlugin.SpaceApplication> apps) {
        int idx = 0;
        for (SpaceApplicationConfigPlugin.SpaceApplication app : apps) {
            ++idx;
            if (!app.getPortletName().equals(this.prevApp)) continue;
            return idx;
        }
        return 0;
    }

    private boolean isTaskExists(List<SpaceApplicationConfigPlugin.SpaceApplication> apps) {
        for (SpaceApplicationConfigPlugin.SpaceApplication app : apps) {
            if (!this.taskAppName.equals(app.getPortletApp()) || !this.taskPortletName.equals(app.getPortletName())) continue;
            return true;
        }
        return false;
    }

    public void stop() {
    }
}

