/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskComment")
@ExoEntity
@Table(name="TASK_COMMENTS")
@NamedQueries(value={@NamedQuery(name="Comment.countCommentOfTask", query="SELECT count(c) FROM TaskComment c WHERE c.task.id = :taskId AND c.parentComment IS NULL"), @NamedQuery(name="Comment.findCommentsOfTask", query="SELECT c FROM TaskComment c WHERE c.task.id = :taskId AND c.parentComment IS NULL ORDER BY c.createdTime DESC"), @NamedQuery(name="Comment.findSubCommentsOfComments", query="SELECT c FROM TaskComment c WHERE c.parentComment IN (:comments) ORDER BY c.createdTime ASC"), @NamedQuery(name="Comment.deleteCommentOfTask", query="DELETE FROM TaskComment c WHERE c.task.id = :taskId"), @NamedQuery(name="Comment.findMentionedUsersOfTask", query="SELECT m FROM TaskComment c INNER JOIN c.mentionedUsers m WHERE c.task.id = :taskId")})
public class Comment {
    private static final Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    @Id
    @SequenceGenerator(name="SEQ_TASK_COMMENTS_COMMENT_ID", sequenceName="SEQ_TASK_COMMENTS_COMMENT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_COMMENTS_COMMENT_ID")
    @Column(name="COMMENT_ID")
    private long id;
    @Column(name="AUTHOR")
    private String author;
    @Column(name="CMT")
    private String comment;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME")
    private Date createdTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TASK_ID")
    private Task task;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="PARENT_COMMENT_ID")
    private Comment parentComment;
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="parentComment", fetch=FetchType.LAZY)
    private List<Comment> subComments = new ArrayList<Comment>();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_COMMENT_MENTIONED_USERS", joinColumns={@JoinColumn(name="COMMENT_ID")})
    @Column(name="MENTIONED_USERS")
    private Set<String> mentionedUsers = new HashSet<String>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.parseMentionedUsers(comment);
    }

    public Set<String> getMentionedUsers() {
        return this.mentionedUsers.stream().collect(Collectors.toSet());
    }

    private void parseMentionedUsers(String comment) {
        HashSet<String> ment = new HashSet<String>();
        if (comment != null && !comment.isEmpty()) {
            Matcher matcher = pattern.matcher(comment);
            StringBuffer buf = new StringBuffer();
            while (matcher.find()) {
                String username = matcher.group().substring(1);
                if (username == null || username.isEmpty()) continue;
                ment.add(username.trim());
            }
        }
        this.mentionedUsers = ment;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public Comment getParentComment() {
        return this.parentComment;
    }

    public void setParentComment(Comment parentComment) {
        this.parentComment = parentComment;
        this.parentComment.addSubComment(this);
    }

    public List<Comment> getSubComments() {
        return this.subComments;
    }

    public void setSubComments(List<Comment> subComments) {
        this.subComments = subComments;
    }

    public void addSubComment(Comment subComment) {
        this.subComments.add(subComment);
    }

    public Comment clone() {
        Comment c = new Comment();
        c.setId(this.getId());
        c.setAuthor(this.getAuthor());
        c.setComment(this.getComment());
        c.setCreatedTime(this.getCreatedTime());
        c.setTask(this.getTask().clone());
        return c;
    }
}

