/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;

public class TaskLoggingListener
extends Listener<TaskService, TaskPayload> {
    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskService service = (TaskService)event.getSource();
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        TaskPayload data = (TaskPayload)event.getData();
        Task oldTask = data.before();
        Task newTask = data.after();
        if (oldTask == null && newTask != null) {
            service.addTaskLog(newTask.getId(), username, "created", "");
        }
        if (oldTask != null && newTask != null) {
            this.logTaskUpdate(service, username, oldTask, newTask);
        }
    }

    private void logTaskUpdate(TaskService service, String username, Task before, Task after) throws EntityNotFoundException {
        NotificationContext ctx;
        if (this.isDiff(before.getStartDate(), after.getStartDate()) || this.isDiff(before.getEndDate(), after.getEndDate())) {
            service.addTaskLog(after.getId(), username, "edit_workplan", "");
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_workplan");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
        if (this.isDiff(before.getTitle(), after.getTitle())) {
            service.addTaskLog(after.getId(), username, "edit_title", "");
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskEditionPlugin");
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_title");
        }
        if (this.isDiff(before.getDueDate(), after.getDueDate())) {
            service.addTaskLog(after.getId(), username, "edit_duedate", "");
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskDueDatePlugin");
        }
        if (this.isDiff(before.getDescription(), after.getDescription())) {
            service.addTaskLog(after.getId(), username, "edit_description", "");
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_description");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
        if (this.isDiff(before.getPriority(), after.getPriority())) {
            service.addTaskLog(after.getId(), username, "edit_priority", "");
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_priority");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
        if (this.isDiff(before.isCompleted(), after.isCompleted())) {
            service.addTaskLog(after.getId(), username, "mark_done", "");
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskCompletedPlugin");
        }
        if (this.isDiff(before.getAssignee(), after.getAssignee())) {
            if (after.getAssignee() != null && !after.getAssignee().trim().isEmpty()) {
                service.addTaskLog(after.getId(), username, "assign", after.getAssignee());
            } else {
                service.addTaskLog(after.getId(), username, "unassign", before.getAssignee());
            }
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskAssignPlugin");
        }
        if (after.getCoworker() != null && !after.getCoworker().isEmpty()) {
            HashSet<String> receiver = new HashSet<String>();
            Set coworkers = before.getCoworker();
            if (coworkers == null) {
                coworkers = Collections.emptySet();
            }
            for (String user : after.getCoworker()) {
                if (coworkers.contains(user)) continue;
                receiver.add(user);
            }
            if (!receiver.isEmpty()) {
                NotificationContext ctx2 = this.buildContext(after);
                ctx2.append(NotificationUtils.COWORKER, receiver);
                this.dispatch(ctx2, "TaskCoworkerPlugin");
            }
        }
        if (this.isProjectChange(before, after)) {
            if (after.getStatus() != null) {
                service.addTaskLog(after.getId(), username, "edit_project", after.getStatus().getProject().getName());
            } else {
                service.addTaskLog(after.getId(), username, "remove_project", "");
            }
        } else if (this.isDiff(before.getStatus(), after.getStatus())) {
            service.addTaskLog(after.getId(), username, "edit_status", after.getStatus().getName());
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_status");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
    }

    private boolean isProjectChange(Task before, Task after) {
        if (!this.isDiff(before.getStatus(), after.getStatus())) {
            return false;
        }
        if (before.getStatus() != null) {
            if (after.getStatus() == null) {
                return true;
            }
            return !before.getStatus().getProject().equals((Object)after.getStatus().getProject());
        }
        return true;
    }

    private boolean isDiff(Object before, Object after) {
        if (before == after) {
            return false;
        }
        if (before != null) {
            return !before.equals(after);
        }
        return !after.equals(before);
    }

    private NotificationContext buildContext(Task task) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.TASK, (Object)task);
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        ctx.append(NotificationUtils.CREATOR, (Object)creator);
        return ctx;
    }

    private void dispatch(NotificationContext ctx, String pluginId) {
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)pluginId))).execute(ctx);
    }
}

