/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.legacy.service.TaskPayload;
import org.exoplatform.task.service.TaskService;

public class TaskLoggingListener
extends Listener<org.exoplatform.task.legacy.service.TaskService, TaskPayload> {
    private TaskService taskService;

    public TaskLoggingListener(TaskService taskService) {
        this.taskService = taskService;
    }

    public void onEvent(Event<org.exoplatform.task.legacy.service.TaskService, TaskPayload> event) throws Exception {
        org.exoplatform.task.legacy.service.TaskService service = (org.exoplatform.task.legacy.service.TaskService)event.getSource();
        if (service == null) {
            service = (org.exoplatform.task.legacy.service.TaskService)CommonsUtils.getService(org.exoplatform.task.legacy.service.TaskService.class);
        }
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        TaskPayload data = (TaskPayload)event.getData();
        Task oldTask = data.before();
        Task newTask = data.after();
        if (oldTask == null && newTask != null) {
            service.addTaskLog(newTask.getId(), username, "created", "");
            this.notifyAssignee(null, newTask, username);
            this.notifyCoworker(null, newTask, username);
        }
        if (oldTask != null && newTask != null) {
            this.logTaskUpdate(service, username, oldTask, newTask);
        }
    }

    private void logTaskUpdate(org.exoplatform.task.legacy.service.TaskService service, String username, Task before, Task after) throws EntityNotFoundException {
        NotificationContext ctx;
        if (this.isDateDiff(before.getStartDate(), after.getStartDate()) || this.isDateDiff(before.getEndDate(), after.getEndDate())) {
            service.addTaskLog(after.getId(), username, "edit_workplan", "");
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_workplan");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
        if (this.isDiff(before.getTitle(), after.getTitle())) {
            service.addTaskLog(after.getId(), username, "edit_title", "");
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskEditionPlugin");
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_title");
        }
        if (this.isDateDiff(before.getDueDate(), after.getDueDate())) {
            service.addTaskLog(after.getId(), username, "edit_duedate", "");
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskDueDatePlugin");
        }
        if (this.isDiff(before.getDescription(), after.getDescription())) {
            service.addTaskLog(after.getId(), username, "edit_description", "");
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_description");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
        if (this.isDiff(before.getPriority(), after.getPriority())) {
            service.addTaskLog(after.getId(), username, "edit_priority", "");
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_priority");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
        if (this.isDiff(before.isCompleted(), after.isCompleted())) {
            service.addTaskLog(after.getId(), username, "mark_done", "");
            ctx = this.buildContext(after);
            this.dispatch(ctx, "TaskCompletedPlugin");
        }
        this.notifyAssignee(before, after, username);
        this.notifyCoworker(before, after, username);
        if (this.isProjectChange(before, after)) {
            if (after.getStatus() != null) {
                service.addTaskLog(after.getId(), username, "edit_project", after.getStatus().getProject().getName());
            } else {
                service.addTaskLog(after.getId(), username, "remove_project", "");
            }
        } else if (this.isDiff(before.getStatus(), after.getStatus())) {
            service.addTaskLog(after.getId(), username, "edit_status", after.getStatus().getName());
            ctx = this.buildContext(after);
            ctx.append(NotificationUtils.ACTION_NAME, (Object)"edit_status");
            this.dispatch(ctx, "TaskEditionPlugin");
        }
    }

    private boolean isDateDiff(Date dateBefore, Date dateAfter) {
        if (dateBefore != null && dateAfter == null) {
            return true;
        }
        if (dateBefore == null && dateAfter != null) {
            return true;
        }
        if (dateBefore != null) {
            return dateBefore.getTime() != dateAfter.getTime();
        }
        return false;
    }

    private void notifyAssignee(Task before, Task after, String username) throws EntityNotFoundException {
        if (before == null || this.isDiff(before.getAssignee(), after.getAssignee())) {
            if (StringUtils.isNotBlank((String)after.getAssignee())) {
                this.taskService.addTaskLog(after.getId(), username, "assign", after.getAssignee());
            } else if (before != null) {
                this.taskService.addTaskLog(after.getId(), username, "unassign", before.getAssignee());
            }
            if (after.getAssignee() != null && !username.equals(after.getAssignee())) {
                NotificationContext ctx = this.buildContext(after);
                this.dispatch(ctx, "TaskAssignPlugin");
            }
        }
    }

    private boolean isProjectChange(Task before, Task after) {
        if (!this.isDiff(before.getStatus(), after.getStatus())) {
            return false;
        }
        if (before.getStatus() != null) {
            if (after.getStatus() == null) {
                return true;
            }
            return !before.getStatus().getProject().equals((Object)after.getStatus().getProject());
        }
        return true;
    }

    private boolean isDiff(Object before, Object after) {
        if (before == after) {
            return false;
        }
        if (before != null) {
            return !before.equals(after);
        }
        return true;
    }

    private NotificationContext buildContext(Task task) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.TASK, (Object)task);
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        ctx.append(NotificationUtils.CREATOR, (Object)creator);
        return ctx;
    }

    private void dispatch(NotificationContext ctx, String pluginId) {
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)pluginId))).execute(ctx);
    }

    private void notifyCoworker(Task before, Task after, String username) {
        HashSet<String> receiver = new HashSet<String>();
        Set<Object> coworkers = new HashSet();
        if (before != null && (coworkers = before.getCoworker()) == null) {
            coworkers = Collections.emptySet();
        }
        if (after.getCoworker() != null && !after.getCoworker().isEmpty()) {
            for (String user : after.getCoworker()) {
                if (coworkers.contains(user) || user.equals(username)) continue;
                receiver.add(user);
            }
        }
        if (!receiver.isEmpty()) {
            NotificationContext ctx = this.buildContext(after);
            ctx.append(NotificationUtils.COWORKER, receiver);
            this.dispatch(ctx, "TaskCoworkerPlugin");
        }
    }
}

