/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.LabelTaskMapping;

@Entity(name="TaskLabel")
@ExoEntity
@Table(name="TASK_LABELS")
@NamedQueries(value={@NamedQuery(name="Label.findLabelsByTask", query="SELECT lbl FROM TaskLabel lbl inner join lbl.lblMapping m WHERE lbl.username = :username AND m.task.id = :taskid"), @NamedQuery(name="Label.findLabelsByTaskCount", query="SELECT count(*) FROM TaskLabel lbl inner join lbl.lblMapping m WHERE lbl.username = :username AND m.task.id = :taskid")})
public class Label {
    @Id
    @SequenceGenerator(name="SEQ_TASK_LABELS_LABEL_ID", sequenceName="SEQ_TASK_LABELS_LABEL_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_LABELS_LABEL_ID")
    @Column(name="LABEL_ID")
    private long id;
    @Column(name="USERNAME", nullable=false)
    private String username;
    private String name;
    private String color;
    private boolean hidden;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_LABEL_ID", nullable=true)
    private Label parent;
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY)
    private List<Label> children = new LinkedList<Label>();
    @OneToMany(mappedBy="label", fetch=FetchType.LAZY)
    private Set<LabelTaskMapping> lblMapping = new HashSet<LabelTaskMapping>();

    public Label() {
    }

    public Label(String name, String username) {
        this.name = name;
        this.username = username;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Label getParent() {
        return this.parent;
    }

    public void setParent(Label parent) {
        this.parent = parent;
    }

    public List<Label> getChildren() {
        return this.children;
    }

    public void setChildren(List<Label> children) {
        this.children = children;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public static enum FIELDS {
        NAME,
        COLOR,
        PARENT,
        HIDDEN;

    }
}

