/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage;

import java.util.List;
import java.util.Set;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;

public interface TaskStorage {
    public TaskDto getTaskById(long var1);

    public TaskDto createTask(TaskDto var1);

    public TaskDto update(TaskDto var1);

    public void delete(TaskDto var1);

    public List<TaskDto> findTasksByLabel(LabelDto var1, List<Long> var2, String var3, OrderBy var4, int var5, int var6) throws Exception;

    public int countTasksByLabel(LabelDto var1, List<Long> var2, String var3, OrderBy var4) throws Exception;

    public List<TaskDto> findByUser(String var1);

    public List<TaskDto> findTasks(TaskQuery var1, int var2, int var3) throws Exception;

    public int countTasks(TaskQuery var1) throws Exception;

    public <T> List<T> selectTaskField(TaskQuery var1, String var2);

    public TaskDto findTaskByActivityId(String var1);

    public void updateStatus(Status var1, Status var2);

    public void updateTaskOrder(long var1, Status var3, long[] var4);

    public Set<String> getCoworker(long var1);

    public TaskDto getTaskWithCoworkers(long var1);

    public List<TaskDto> getUncompletedTasks(String var1, int var2);

    public List<TaskDto> getAssignedTasks(String var1, int var2);

    public Long countAssignedTasks(String var1);

    public List<TaskDto> getWatchedTasks(String var1, int var2);

    public Long countUncompletedTasks(String var1);

    public Long countWatchedTasks(String var1);

    public List<TaskDto> getCollaboratedTasks(String var1, int var2);

    public Long countCollaboratedTasks(String var1);

    public List<TaskDto> getIncomingTasks(String var1, int var2, int var3) throws Exception;

    public int countIncomingTasks(String var1) throws Exception;

    public List<TaskDto> getOverdueTasks(String var1, int var2);

    public Long countOverdueTasks(String var1);

    public void addWatcherToTask(String var1, TaskDto var2) throws Exception;

    public void deleteWatcherOfTask(String var1, TaskDto var2) throws Exception;

    public Set<String> getWatchersOfTask(TaskDto var1);

    public List<TaskDto> findTasks(String var1, String var2, int var3);

    public long countTasks(String var1, String var2);

    public ChangeLogEntry addTaskLog(ChangeLogEntry var1) throws EntityNotFoundException;

    public List<ChangeLogEntry> getTaskLogs(long var1, int var3, int var4) throws Exception;

    public List<Object[]> countTaskStatusByProject(long var1);

    public ChangeLog changeLogToEntity(ChangeLogEntry var1);

    public ChangeLogEntry changeLogToDto(ChangeLog var1);

    public Task toEntity(TaskDto var1);

    public TaskDto toDto(Task var1);
}

