/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dto;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.task.domain.Label;

public class LabelDto
implements Serializable {
    private long id;
    private String username;
    private String name;
    private String color;
    private boolean hidden;
    private LabelDto parent;
    private List<LabelDto> children;

    public LabelDto(Label label) {
        this.id = label.getId();
        this.username = label.getUsername();
        this.name = label.getName();
        this.color = label.getColor();
        this.hidden = label.isHidden();
        this.parent = LabelDto.labelToDto(label.getParent());
    }

    public LabelDto getParent() {
        return this.parent;
    }

    public void setParent(LabelDto parent) {
        this.parent = this.equals(parent) ? null : parent;
    }

    public static LabelDto labelToDto(Label label) {
        if (label == null) {
            return null;
        }
        LabelDto labelDto = new LabelDto(label);
        labelDto.setId(label.getId());
        labelDto.setUsername(label.getUsername());
        labelDto.setName(label.getName());
        labelDto.setColor(label.getColor());
        labelDto.setHidden(label.isHidden());
        labelDto.setParent(LabelDto.labelToDto(label.getParent()));
        return labelDto;
    }

    public static Label labelToEntity(LabelDto labelDto) {
        if (labelDto == null) {
            return null;
        }
        Label label = new Label();
        label.setId(labelDto.getId());
        label.setUsername(labelDto.getUsername());
        label.setName(labelDto.getName());
        label.setColor(labelDto.getColor());
        label.setHidden(labelDto.isHidden());
        label.setParent(LabelDto.labelToEntity(labelDto.getParent()));
        return label;
    }

    public long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<LabelDto> getChildren() {
        return this.children;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setChildren(List<LabelDto> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelDto)) {
            return false;
        }
        LabelDto other = (LabelDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        LabelDto this$parent = this.getParent();
        LabelDto other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<LabelDto> this$children = this.getChildren();
        List<LabelDto> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LabelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        result = result * 59 + (this.isHidden() ? 79 : 97);
        LabelDto $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<LabelDto> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "LabelDto(id=" + this.getId() + ", username=" + this.getUsername() + ", name=" + this.getName() + ", color=" + this.getColor() + ", hidden=" + this.isHidden() + ", parent=" + this.getParent() + ", children=" + this.getChildren() + ")";
    }

    public LabelDto() {
    }
}

