/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.AbstractNotificationPlugin;
import org.exoplatform.task.integration.notification.NotificationUtils;

public class TaskCommentPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "TaskCommentedPlugin";

    public TaskCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    @Override
    public NotificationInfo makeNotification(NotificationContext ctx) {
        TaskDto task = (TaskDto)ctx.value(NotificationUtils.TASK);
        CommentDto comment = (CommentDto)ctx.value(NotificationUtils.COMMENT);
        NotificationInfo info = super.makeNotification(ctx);
        info.with("tasks", String.valueOf(task.getId()));
        info.with("commentText", comment.getComment());
        Object projectId = "project.";
        if (task.getStatus() != null) {
            projectId = (String)projectId + String.valueOf(task.getStatus().getProject().getId());
        }
        info.with("activityId", (String)projectId);
        return info;
    }

    public boolean isValid(NotificationContext ctx) {
        Set receivers = (Set)ctx.value(NotificationUtils.RECEIVERS);
        return receivers != null && receivers.size() > 0;
    }

    @Override
    protected Set<String> getReceiver(TaskDto task, NotificationContext ctx) {
        return (Set)ctx.value(NotificationUtils.RECEIVERS);
    }
}

