/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.domain.Project;

public class ProjectDAOImpl
extends GenericDAOJPAImpl<Project, Long>
implements ProjectHandler {
    private static final Logger LOG = Logger.getLogger("ProjectDAOImpl");
    private EntityManagerService entityService;

    public ProjectDAOImpl(EntityManagerService entityService) {
        this.entityService = entityService;
    }

    public EntityManager getEntityManager() {
        return this.entityService.getEntityManager();
    }

    @Override
    public List<Project> findSubProjects(Project project) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNamedQuery(project != null ? "Project.findSubProjects" : "Project.getRootProjects");
        if (project != null) {
            query.setParameter("projectId", (Object)project.getId());
        }
        return query.getResultList();
    }

    @Override
    public List<Project> findSubProjectsByMemberships(Project project, List<String> memberships) {
        EntityManager em = this.getEntityManager();
        Query query = em.createNamedQuery(project != null ? "Project.findSubProjectsByMemberships" : "Project.findRootProjectsByMemberships");
        if (project != null) {
            query.setParameter("projectId", (Object)project.getId());
        }
        query.setParameter("memberships", memberships);
        return query.getResultList();
    }

    @Override
    public List<Project> findAllByMemberships(List<String> memberships) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Project.findAllByMembership", Project.class);
        query.setParameter("memberships", memberships);
        return query.getResultList();
    }

    @Override
    public List<Project> findAllByMembershipsAndKeyword(List<String> memberships, String keyword) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Project.findAllByMembershipAndKeyword", Project.class);
        query.setParameter("memberships", memberships);
        keyword = keyword == null || keyword.isEmpty() ? "%" : "%" + keyword.toUpperCase() + "%";
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }
}

