/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.utils.TaskUtil;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;

public class ActivityTaskProcessor
extends BaseActivityProcessorPlugin {
    private final DAOHandler daoHandler;
    private final EntityManagerService entityManagerService;
    private final WebAppController webAppController;

    public ActivityTaskProcessor(InitParams params, WebAppController controller, DAOHandler daoHandler, EntityManagerService entityManagerService) {
        super(params);
        this.entityManagerService = entityManagerService;
        this.daoHandler = daoHandler;
        this.webAppController = controller;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            activity.setTitle(this.substituteTask(activity.getTitle(), activity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substituteTask(String message, ExoSocialActivity activity) {
        if (message == null) {
            return null;
        }
        int idx = message.indexOf("++");
        if (idx >= 0) {
            try {
                RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
                Task task = this.daoHandler.getTaskHandler().findTaskByActivityId(activity.getId());
                if (task != null) {
                    String string = ActivityTaskProcessor.substituteTask(task, message, this.webAppController.getRouter());
                    return string;
                }
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        return message;
    }

    static String substituteTask(Task task, String title, Router router) {
        if (task == null || title == null) {
            return title;
        }
        int idx = title.indexOf("++");
        if (idx == -1) {
            return title;
        }
        int breakIdx = title.indexOf("<br", idx);
        StringBuilder builder = new StringBuilder(title);
        String taskURL = TaskUtil.buildTaskURL(task, SiteKey.portal((String)"intranet"), ExoContainerContext.getCurrentContainer(), router);
        String url = " <a href='" + taskURL + "'>";
        builder.insert(idx, url);
        if (breakIdx > 0) {
            builder.insert(breakIdx += url.length(), "</a>");
        } else {
            builder.append("</a>");
        }
        return builder.toString();
    }
}

