/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.model;

public class GroupKey<T>
implements Comparable<GroupKey> {
    private final String name;
    private final T value;
    private final int rank;

    public GroupKey(String name, T value, int rank) {
        this.name = name;
        this.value = value;
        this.rank = rank;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public int getRank() {
        return this.rank;
    }

    @Override
    public int compareTo(GroupKey o) {
        int compare = Integer.compare(this.rank, o.rank);
        if (compare == 0) {
            if (this.value != null && this.value instanceof Comparable) {
                if (o.value == null) {
                    compare = 1;
                } else if (o.value.getClass() == this.value.getClass()) {
                    compare = ((Comparable)this.value).compareTo(o.value);
                }
            } else if (this.value == null && o.value != null) {
                compare = -1;
            }
        }
        return compare;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupKey groupKey = (GroupKey)o;
        return !(this.name != null ? !this.name.equals(groupKey.name) : groupKey.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

