/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure13;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure15;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure17;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure19;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure21;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.ProjectServiceImpl$AjcClosure9;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.UserUtils;

@Singleton
public class ProjectServiceImpl
implements ProjectService {
    private static final Log LOG;
    @Inject
    StatusService statusService;
    @Inject
    TaskService taskService;
    @Inject
    DAOHandler daoHandler;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public ProjectServiceImpl() {
    }

    public ProjectServiceImpl(StatusService statusService, TaskService taskService, DAOHandler daoHandler) {
        this.daoHandler = daoHandler;
        this.statusService = statusService;
        this.taskService = taskService;
    }

    @Override
    @ExoTransactional
    public Project createDefaultStatusProjectWithManager(String name, String description, Long parentId, String username) throws ProjectNotFoundException {
        String string = name;
        String string2 = description;
        Long l = parentId;
        String string3 = username;
        Object[] objectArray = new Object[]{string, string2, l, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, l, string3, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project createDefaultStatusProjectWithAttributes(Long parentId, String name, String description, Set<String> managers, Set<String> participators) throws ProjectNotFoundException {
        Long l = parentId;
        String string = name;
        String string2 = description;
        Set<String> set = managers;
        Set<String> set2 = participators;
        Object[] objectArray = new Object[]{l, string, string2, set, set2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, l, string, string2, set, set2, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project createDefaultStatusProject(Project project) {
        Project project2 = project;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)project2);
        Object[] objectArray = new Object[]{this, project2, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project createProject(Project project) {
        Project project2 = project;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)project2);
        Object[] objectArray = new Object[]{this, project2, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project updateProjectInfo(long id, String param, String[] values) throws ProjectNotFoundException, ParameterEntityException {
        long l = id;
        String string = param;
        String[] stringArray = values;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, stringArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, stringArray, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteProjectById(long id, boolean deleteChild) throws ProjectNotFoundException {
        long l = id;
        boolean bl = deleteChild;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteProject(Project project, boolean deleteChild) {
        Project project2 = project;
        boolean bl = deleteChild;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)project2, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, project2, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project cloneProjectById(long id, boolean cloneTask) throws ProjectNotFoundException {
        long l = id;
        boolean bl = cloneTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), Conversions.booleanObject((boolean)bl), joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Project getProjectById(Long id) throws ProjectNotFoundException {
        Project project = (Project)this.daoHandler.getProjectHandler().find(id);
        if (project == null) {
            throw new ProjectNotFoundException(id);
        }
        return project;
    }

    @Override
    @ExoTransactional
    public Task createTaskToProjectId(long id, Task task) throws ProjectNotFoundException {
        long l = id;
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)task2);
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), task2, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<Task> getTasksByProjectId(List<Long> ids, OrderBy orderBy) {
        return this.getTasksWithKeywordByProjectId(ids, orderBy, null);
    }

    @Override
    public List<Task> getTasksWithKeywordByProjectId(List<Long> ids, OrderBy orderBy, String keyword) {
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProjectIds(ids);
        taskQuery.setKeyword(keyword);
        taskQuery.setOrderBy(orderBy == null ? null : Arrays.asList(orderBy));
        taskQuery.setCompleted(false);
        return this.daoHandler.getTaskHandler().findTaskByQuery(taskQuery);
    }

    @Override
    @ExoTransactional
    public Project removePermissionFromProjectId(Long id, String permission, String type) throws ProjectNotFoundException, NotAllowedOperationOnEntityException {
        Long l = id;
        String string = permission;
        String string2 = type;
        Object[] objectArray = new Object[]{l, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, l, string, string2, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Project addPermissionsFromProjectId(Long id, String permissions, String type) throws ProjectNotFoundException, NotAllowedOperationOnEntityException {
        Long l = id;
        String string = permissions;
        String string2 = type;
        Object[] objectArray = new Object[]{l, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, l, string, string2, joinPoint};
        return (Project)ExoTransactionalAspect.aspectOf().around(new ProjectServiceImpl$AjcClosure21(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<Project> getProjectTreeByMembership(List<String> memberships) {
        List<Project> projects = this.daoHandler.getProjectHandler().findAllByMemberships(memberships);
        return ProjectUtil.buildRootProjects(projects);
    }

    @Override
    public List<Project> findProjectByKeyWord(Identity identity, String keyword, OrderBy order) {
        List<String> memberships = UserUtils.getMemberships(identity);
        return this.daoHandler.getProjectHandler().findAllByMembershipsAndKeyword(memberships, keyword, order);
    }

    static {
        ProjectServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(ProjectServiceImpl.class);
    }

    static /* synthetic */ Project createDefaultStatusProjectWithManager_aroundBody0(ProjectServiceImpl ajc$this, String name, String description, Long parentId, String username, JoinPoint joinPoint) {
        HashSet<String> managers = new HashSet<String>();
        managers.add(username);
        return ajc$this.createDefaultStatusProjectWithAttributes(parentId, name, description, managers, Collections.<String>emptySet());
    }

    static /* synthetic */ Project createDefaultStatusProjectWithAttributes_aroundBody2(ProjectServiceImpl ajc$this, Long parentId, String name, String description, Set managers, Set participators, JoinPoint joinPoint) {
        Project project = new Project(name, description, new HashSet<Status>(), managers, participators);
        if (parentId != null && parentId != 0L) {
            Project parentProject = (Project)ajc$this.daoHandler.getProjectHandler().find(parentId);
            if (parentProject != null) {
                project.setParent(parentProject);
                project.setParticipator(new HashSet<String>(parentProject.getParticipator()));
                project.setManager(new HashSet<String>(parentProject.getManager()));
                project = ajc$this.createProject(project);
                LinkedList<Status> prSt = new LinkedList<Status>(parentProject.getStatus());
                Collections.sort(prSt);
                for (Status st : prSt) {
                    ajc$this.statusService.createStatus(project, st.getName());
                }
                return project;
            }
            LOG.info((Object)("Can not find project for parent with ID: " + parentId));
            throw new ProjectNotFoundException(parentId);
        }
        return ajc$this.createDefaultStatusProject(project);
    }

    static /* synthetic */ Project createDefaultStatusProject_aroundBody4(ProjectServiceImpl ajc$this, Project project, JoinPoint joinPoint) {
        Project newProject = (Project)ajc$this.daoHandler.getProjectHandler().create(project);
        for (String s : ajc$this.statusService.getDefaultStatus()) {
            ajc$this.statusService.createStatus(newProject, s);
        }
        return newProject;
    }

    static /* synthetic */ Project createProject_aroundBody6(ProjectServiceImpl ajc$this, Project project, JoinPoint joinPoint) {
        Project obj = (Project)ajc$this.daoHandler.getProjectHandler().create(project);
        return obj;
    }

    static /* synthetic */ Project updateProjectInfo_aroundBody8(ProjectServiceImpl ajc$this, long id, String param, String[] values, JoinPoint joinPoint) {
        String val = values != null && values.length > 0 ? values[0] : null;
        Project project = ajc$this.getProjectById(id);
        if ("name".equalsIgnoreCase(param)) {
            if (val == null || val.isEmpty()) {
                LOG.info((Object)"Name of project must not empty");
                throw new ParameterEntityException(id, "Project", param, val, "must not be empty", null);
            }
            project.setName(val);
        } else if ("manager".equalsIgnoreCase(param)) {
            HashSet<String> manager = new HashSet<String>();
            if (values != null) {
                for (String v : values) {
                    manager.add(v);
                }
            }
            project.setManager(manager);
        } else if ("participator".equalsIgnoreCase(param)) {
            HashSet<String> participator = new HashSet<String>();
            if (values == null) {
                // empty if block
            }
            for (String v : values) {
                participator.add(v);
            }
            project.setParticipator(participator);
        } else if ("dueDate".equalsIgnoreCase(param)) {
            if (val == null || val.isEmpty()) {
                project.setDueDate(null);
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date date = df.parse(val);
                    project.setDueDate(date);
                }
                catch (ParseException e) {
                    LOG.info((Object)("can not parse date string: " + val));
                    throw new ParameterEntityException(id, "Project", param, val, "cannot be parse to date", e);
                }
            }
        } else if ("description".equalsIgnoreCase(param)) {
            project.setDescription(val);
        } else if ("color".equalsIgnoreCase(param)) {
            project.setColor(val);
        } else if ("calendarIntegrated".equalsIgnoreCase(param)) {
            project.setCalendarIntegrated(Boolean.parseBoolean(val));
        } else if ("parent".equalsIgnoreCase(param)) {
            try {
                long projectId = Long.parseLong(val);
                if (projectId == 0L) {
                    project.setParent(null);
                }
                if (projectId == project.getId()) {
                    throw new ParameterEntityException(id, "Project", param, val, "project can not be child of itself", null);
                }
                Project parent = ajc$this.getProjectById(projectId);
                project.setParent(parent);
            }
            catch (NumberFormatException ex) {
                LOG.info((Object)("can not parse date string: " + val));
                throw new ParameterEntityException(id, "Project", param, val, "cannot be parse to Long", ex);
            }
        } else {
            LOG.info((Object)("Field name: " + param + " is not supported for entity Project"));
            throw new ParameterEntityException(id, "Project", param, val, "is not supported for the entity Project", null);
        }
        Project obj = (Project)ajc$this.daoHandler.getProjectHandler().update(project);
        return obj;
    }

    static /* synthetic */ void deleteProjectById_aroundBody10(ProjectServiceImpl ajc$this, long id, boolean deleteChild, JoinPoint joinPoint) {
        Project project = ajc$this.getProjectById(id);
        ajc$this.deleteProject(project, deleteChild);
    }

    static /* synthetic */ void deleteProject_aroundBody12(ProjectServiceImpl ajc$this, Project project, boolean deleteChild, JoinPoint joinPoint) {
        if (!deleteChild && project.getChildren() != null) {
            Project parent = project.getParent();
            for (Project child : project.getChildren()) {
                child.setParent(parent);
            }
            project.getChildren().clear();
        }
        ajc$this.daoHandler.getProjectHandler().delete(project);
    }

    static /* synthetic */ Project cloneProjectById_aroundBody14(ProjectServiceImpl ajc$this, long id, boolean cloneTask, JoinPoint joinPoint) {
        Project project = ajc$this.getProjectById(id);
        Project newProject = project.clone(cloneTask);
        ajc$this.createProject(newProject);
        return newProject;
    }

    static /* synthetic */ Task createTaskToProjectId_aroundBody16(ProjectServiceImpl ajc$this, long id, Task task, JoinPoint joinPoint) {
        Status status = ajc$this.daoHandler.getStatusHandler().findLowestRankStatusByProject(id);
        task.setStatus(status);
        return ajc$this.taskService.createTask(task);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ Project removePermissionFromProjectId_aroundBody18(ProjectServiceImpl ajc$this, Long id, String permission, String type, JoinPoint joinPoint) {
        Project project = (Project)ajc$this.daoHandler.getProjectHandler().find(id);
        if (project == null) {
            LOG.info((Object)("Can not find project with ID: " + id));
            throw new ProjectNotFoundException(id);
        }
        if ("manager".equals(type)) {
            if (project.getManager().size() <= 1) {
                LOG.info((Object)("Not allow to remove last manager for project with ID: " + id));
                throw new NotAllowedOperationOnEntityException((long)id, "Project", "Remove last manager");
            }
            project.getManager().remove(permission);
            return (Project)ajc$this.daoHandler.getProjectHandler().update(project);
        } else {
            project.getParticipator().remove(permission);
        }
        return (Project)ajc$this.daoHandler.getProjectHandler().update(project);
    }

    static /* synthetic */ Project addPermissionsFromProjectId_aroundBody20(ProjectServiceImpl ajc$this, Long id, String permissions, String type, JoinPoint joinPoint) {
        Project project = ajc$this.getProjectById(id);
        if (permissions != null) {
            HashSet<String> per = new HashSet<String>();
            MembershipEntry entry = MembershipEntry.parse((String)permissions);
            if (entry != null) {
                per.add(entry.toString());
            } else {
                String[] users = permissions.split(",");
                for (int i = 0; i < users.length; ++i) {
                    per.add(users[i]);
                }
            }
            if ("manager".equals(type)) {
                project.getManager().addAll(per);
            } else {
                project.getParticipator().addAll(per);
            }
            Project obj = (Project)ajc$this.daoHandler.getProjectHandler().update(project);
            return obj;
        }
        LOG.info((Object)("Add permissions equal to null (not allow) to Project with ID: " + id));
        throw new NotAllowedOperationOnEntityException((long)id, "Project", "Add permission equal to null");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProjectServiceImpl.java", ProjectServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createDefaultStatusProjectWithManager", "org.exoplatform.task.service.impl.ProjectServiceImpl", "java.lang.String:java.lang.String:java.lang.Long:java.lang.String", "name:description:parentId:username", "org.exoplatform.task.exception.ProjectNotFoundException", "org.exoplatform.task.domain.Project"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createDefaultStatusProjectWithAttributes", "org.exoplatform.task.service.impl.ProjectServiceImpl", "java.lang.Long:java.lang.String:java.lang.String:java.util.Set:java.util.Set", "parentId:name:description:managers:participators", "org.exoplatform.task.exception.ProjectNotFoundException", "org.exoplatform.task.domain.Project"), 100);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPermissionsFromProjectId", "org.exoplatform.task.service.impl.ProjectServiceImpl", "java.lang.Long:java.lang.String:java.lang.String", "id:permissions:type", "org.exoplatform.task.exception.ProjectNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.domain.Project"), 322);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createDefaultStatusProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.domain.Project", "project", "", "org.exoplatform.task.domain.Project"), 133);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.domain.Project", "project", "", "org.exoplatform.task.domain.Project"), 144);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProjectInfo", "org.exoplatform.task.service.impl.ProjectServiceImpl", "long:java.lang.String:[Ljava.lang.String;", "id:param:values", "org.exoplatform.task.exception.ProjectNotFoundException:org.exoplatform.task.exception.ParameterEntityException", "org.exoplatform.task.domain.Project"), 153);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteProjectById", "org.exoplatform.task.service.impl.ProjectServiceImpl", "long:boolean", "id:deleteChild", "org.exoplatform.task.exception.ProjectNotFoundException", "void"), 225);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteProject", "org.exoplatform.task.service.impl.ProjectServiceImpl", "org.exoplatform.task.domain.Project:boolean", "project:deleteChild", "", "void"), 233);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneProjectById", "org.exoplatform.task.service.impl.ProjectServiceImpl", "long:boolean", "id:cloneTask", "org.exoplatform.task.exception.ProjectNotFoundException", "org.exoplatform.task.domain.Project"), 247);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskToProjectId", "org.exoplatform.task.service.impl.ProjectServiceImpl", "long:org.exoplatform.task.domain.Task", "id:task", "org.exoplatform.task.exception.ProjectNotFoundException", "org.exoplatform.task.domain.Task"), 269);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removePermissionFromProjectId", "org.exoplatform.task.service.impl.ProjectServiceImpl", "java.lang.Long:java.lang.String:java.lang.String", "id:permission:type", "org.exoplatform.task.exception.ProjectNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.domain.Project"), 296);
    }
}

