/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.domain.TaskLog;
import org.exoplatform.task.exception.CommentNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.exception.StatusNotFoundException;
import org.exoplatform.task.exception.TaskNotFoundException;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.service.TaskListener;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.TaskEvent;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure13;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure15;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure17;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure9;

@Singleton
public class TaskServiceImpl
implements TaskService {
    private static final Log LOG;
    @Inject
    private DAOHandler daoHandler;
    private List<TaskListener> listeners = new LinkedList<TaskListener>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public TaskServiceImpl(DAOHandler daoHandler) {
        this.daoHandler = daoHandler;
        for (TaskListener listener : ServiceLoader.load(TaskListener.class)) {
            this.listeners.add(listener);
        }
    }

    public static TaskServiceImpl createInstance(DAOHandler hl, List<TaskListener> ls) {
        TaskServiceImpl sv = new TaskServiceImpl(hl);
        sv.listeners = ls;
        return sv;
    }

    @Override
    @ExoTransactional
    public Task createTask(Task task) {
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)task2);
        Object[] objectArray = new Object[]{this, task2, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task updateTaskInfo(long id, String param, String[] values, TimeZone timezone) throws TaskNotFoundException, ParameterEntityException, StatusNotFoundException {
        long l = id;
        String string = param;
        String[] stringArray = values;
        TimeZone timeZone = timezone;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, stringArray, timeZone};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, stringArray, timeZone, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        long l = currentTaskId;
        Status status = newStatus;
        long[] lArray = orders;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), status, lArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), status, lArray, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task updateTaskCompleted(long id, Boolean completed) throws TaskNotFoundException, ParameterEntityException, StatusNotFoundException {
        long l = id;
        Boolean bl = completed;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)bl);
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), bl, joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteTask(Task task) {
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)task2);
        Object[] objectArray = new Object[]{this, task2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteTaskById(long id) throws TaskNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Task cloneTaskById(long id) throws TaskNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (Task)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Task getTaskById(long id) throws TaskNotFoundException {
        Task task = (Task)this.daoHandler.getTaskHandler().find(Long.valueOf(id));
        if (task == null) {
            LOG.info((Object)("Can not find task with ID: " + id));
            throw new TaskNotFoundException(id);
        }
        return task;
    }

    @Override
    public Long getNbOfCommentsByTask(Task task) {
        return this.daoHandler.getCommentHandler().count(task);
    }

    @Override
    public List<Comment> getCommentsByTaskId(long id, int start, int limit) throws TaskNotFoundException {
        Task task = this.getTaskById(id);
        return this.getCommentsByTask(task, start, limit);
    }

    @Override
    public List<Comment> getCommentsByTask(Task task, int start, int limit) {
        return this.daoHandler.getCommentHandler().findCommentsOfTask(task, start, limit);
    }

    @Override
    @ExoTransactional
    public Comment addCommentToTaskId(long id, String username, String comment) throws TaskNotFoundException {
        long l = id;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, joinPoint};
        return (Comment)ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Override
    public TaskLog addTaskLog(long id, String username, String msg, String target) throws TaskNotFoundException {
        Task task = this.getTaskById(id);
        TaskLog log = new TaskLog();
        log.setAuthor(username);
        log.setMsg(msg);
        log.setTarget(target);
        task.getTaskLogs().add(log);
        this.daoHandler.getTaskHandler().update(task);
        return log;
    }

    @Override
    @ExoTransactional
    public void deleteCommentById(long commentId) throws CommentNotFoundException {
        long l = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new TaskServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<Task> getIncomingTasksByUser(String username, OrderBy orderBy) {
        return this.daoHandler.getTaskHandler().getIncomingTask(username, orderBy);
    }

    @Override
    public List<Task> getToDoTasksByUser(String username, List<Long> projectIds, OrderBy orderBy, Date fromDueDate, Date toDueDate) {
        return this.daoHandler.getTaskHandler().getToDoTask(username, projectIds, orderBy, fromDueDate, toDueDate);
    }

    @Override
    public List<Task> findTaskByQuery(TaskQuery query) {
        return this.daoHandler.getTaskHandler().findTaskByQuery(query);
    }

    @Override
    public long getTaskNum(String username, List<Long> projectIds) {
        return this.daoHandler.getTaskHandler().getTaskNum(username, projectIds);
    }

    private Task updateTask(Task task) {
        return (Task)this.daoHandler.getTaskHandler().update(task);
    }

    private void triggerEvent(TaskEvent event) {
        for (TaskListener listener : this.listeners) {
            listener.event(event);
        }
    }

    static {
        TaskServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(TaskServiceImpl.class);
    }

    static /* synthetic */ Task createTask_aroundBody0(TaskServiceImpl ajc$this, Task task, JoinPoint joinPoint) {
        Task result = (Task)ajc$this.daoHandler.getTaskHandler().create(task);
        TaskEvent.EventBuilder builder = new TaskEvent.EventBuilder(ajc$this);
        builder.withTask(result).withType(TaskEvent.Type.CREATED);
        ajc$this.triggerEvent(builder.build());
        return result;
    }

    static /* synthetic */ Task updateTaskInfo_aroundBody2(TaskServiceImpl ajc$this, long id, String param, String[] values, TimeZone timezone, JoinPoint joinPoint) {
        Task task = ajc$this.getTaskById(id);
        if (task == null) {
            LOG.info((Object)("Can not find task with ID: " + id));
            throw new TaskNotFoundException(id);
        }
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        TaskEvent.EventBuilder builder = new TaskEvent.EventBuilder(ajc$this);
        builder.withTask(task);
        if ("workPlan".equalsIgnoreCase(param)) {
            long oldStartTime = -1L;
            if (task.getStartDate() != null) {
                oldStartTime = task.getStartDate().getTime();
            }
            long oldEndTime = -1L;
            if (task.getEndDate() != null) {
                oldEndTime = task.getEndDate().getTime();
            }
            builder.withType(TaskEvent.Type.EDIT_WORKPLAN).withOldVal(oldStartTime + "/" + oldEndTime);
            if (values == null) {
                task.setStartDate(null);
                task.setEndDate(null);
            } else {
                if (values.length != 2) {
                    LOG.error((Object)"workPlan updating lack of params");
                }
                try {
                    SimpleDateFormat wpf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    wpf.setTimeZone(timezone);
                    Date startDate = wpf.parse(values[0]);
                    Date endDate = wpf.parse(values[1]);
                    task.setStartDate(startDate);
                    task.setEndDate(endDate);
                    builder.withNewVal(startDate.getTime() + "/" + endDate.getTime());
                }
                catch (ParseException ex) {
                    LOG.info((Object)("Can parse date time value: " + values[0] + " or " + values[1] + " for Task with ID: " + id));
                    throw new ParameterEntityException(id, "Task", param, values[0] + " or " + values[1], "cannot be parse to date", ex);
                }
            }
        } else {
            String value;
            String string = value = values != null && values.length > 0 ? values[0] : null;
            if ("title".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.EDIT_TITLE).withOldVal(task.getTitle());
                task.setTitle(value);
                builder.withNewVal(task.getTitle());
            } else if ("dueDate".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.EDIT_DUEDATE).withOldVal(task.getDueDate());
                if (value == null || value.trim().isEmpty()) {
                    task.setDueDate(null);
                } else {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    df.setTimeZone(timezone);
                    try {
                        Date date = df.parse(value);
                        task.setDueDate(date);
                        builder.withNewVal(task.getDueDate());
                    }
                    catch (ParseException ex) {
                        LOG.info((Object)("Can parse date time value: " + value + " for Task with ID: " + id));
                        throw new ParameterEntityException(id, "Task", param, value, "cannot be parse to date", ex);
                    }
                }
            } else if ("status".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.EDIT_STATUS).withOldVal(task.getStatus());
                try {
                    Long statusId = Long.parseLong(value);
                    Status status = (Status)ajc$this.daoHandler.getStatusHandler().find(statusId);
                    if (status == null) {
                        LOG.info((Object)("Status does not exist with ID: " + value));
                        throw new StatusNotFoundException(id);
                    }
                    task.setStatus(status);
                    builder.withNewVal(task.getStatus());
                }
                catch (NumberFormatException ex) {
                    LOG.info((Object)("Status is unacceptable: " + value + " for Task with ID: " + id));
                    throw new ParameterEntityException(id, "Task", param, value, "is unacceptable", ex);
                }
            } else if ("description".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.EDIT_DESCRIPTION).withOldVal(task.getDescription());
                task.setDescription(value);
                builder.withNewVal(task.getDescription());
            } else if ("completed".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.MARK_DONE).withOldVal(task.isCompleted());
                task.setCompleted(Boolean.parseBoolean(value));
                builder.withNewVal(task.isCompleted());
            } else if ("assignee".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.EDIT_ASSIGNEE).withOldVal(task.getAssignee());
                task.setAssignee(value);
                builder.withNewVal(task.getAssignee());
            } else if ("coworker".equalsIgnoreCase(param)) {
                HashSet<String> coworker = new HashSet<String>();
                if (values != null) {
                    for (String v : values) {
                        if (v == null || v.isEmpty()) continue;
                        coworker.add(v);
                    }
                }
                task.setCoworker(coworker);
            } else if ("tags".equalsIgnoreCase(param)) {
                Set<String> old = task.getTag();
                HashSet<String> tags = new HashSet<String>();
                for (String t : values) {
                    tags.add(t);
                }
                task.setTag(tags);
                HashSet<String> newTags = new HashSet<String>(task.getTag());
                builder.withType(TaskEvent.Type.ADD_LABEL).withNewVal(newTags.removeAll(old));
            } else if ("priority".equalsIgnoreCase(param)) {
                Priority priority = Priority.valueOf(value);
                task.setPriority(priority);
            } else if ("project".equalsIgnoreCase(param)) {
                builder.withType(TaskEvent.Type.EDIT_PROJECT).withOldVal(task.getStatus() != null ? task.getStatus().getProject() : null);
                try {
                    Long projectId = Long.parseLong(value);
                    if (projectId > 0L) {
                        Status st = ajc$this.daoHandler.getStatusHandler().findLowestRankStatusByProject(projectId);
                        if (st == null) {
                            throw new ParameterEntityException(id, "Task", param, value, "Status for project is not found", null);
                        }
                        task.setStatus(st);
                        builder.withNewVal(task.getStatus().getProject());
                    }
                    task.setStatus(null);
                }
                catch (NumberFormatException ex) {
                    throw new ParameterEntityException(id, "Task", param, value, "ProjectID must be long", ex);
                }
            } else if ("calendarIntegrated".equalsIgnoreCase(param)) {
                task.setCalendarIntegrated(Boolean.parseBoolean(value));
            } else {
                LOG.info((Object)("Field name: " + param + " is not supported for entity Task"));
                throw new ParameterEntityException(id, "Task", param, value, "is not supported for the entity Task", null);
            }
        }
        Task result = ajc$this.updateTask(task);
        TaskEvent event = builder.build();
        if (event.getType() != null) {
            ajc$this.triggerEvent(builder.build());
        }
        if ("status".equalsIgnoreCase(param) && values.length > 2) {
            long[] taskIds = new long[values.length - 1];
            int currentTaskIndex = -1;
            for (int i = 1; i < values.length; ++i) {
                taskIds[i - 1] = Long.parseLong(values[i]);
                if (taskIds[i - 1] != id) continue;
                currentTaskIndex = i - 1;
            }
            if (currentTaskIndex > -1) {
                // empty if block
            }
        }
        return result;
    }

    static /* synthetic */ void updateTaskOrder_aroundBody4(TaskServiceImpl ajc$this, long currentTaskId, Status newStatus, long[] orders, JoinPoint joinPoint) {
        ajc$this.daoHandler.getTaskHandler().updateTaskOrder(currentTaskId, newStatus, orders);
    }

    static /* synthetic */ Task updateTaskCompleted_aroundBody6(TaskServiceImpl ajc$this, long id, Boolean completed, JoinPoint joinPoint) {
        String[] values = new String[]{completed.toString()};
        return ajc$this.updateTaskInfo(id, "completed", values, null);
    }

    static /* synthetic */ void deleteTask_aroundBody8(TaskServiceImpl ajc$this, Task task, JoinPoint joinPoint) {
        ajc$this.daoHandler.getTaskHandler().delete(task);
    }

    static /* synthetic */ void deleteTaskById_aroundBody10(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        Task task = ajc$this.getTaskById(id);
        ajc$this.deleteTask(task);
    }

    static /* synthetic */ Task cloneTaskById_aroundBody12(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        Task task = ajc$this.getTaskById(id);
        Task newTask = task.clone();
        return ajc$this.createTask(newTask);
    }

    static /* synthetic */ Comment addCommentToTaskId_aroundBody14(TaskServiceImpl ajc$this, long id, String username, String comment, JoinPoint joinPoint) {
        Task task = ajc$this.getTaskById(id);
        Comment newComment = new Comment();
        newComment.setTask(task);
        newComment.setAuthor(username);
        newComment.setComment(comment);
        newComment.setCreatedTime(new Date());
        Comment obj = (Comment)ajc$this.daoHandler.getCommentHandler().create(newComment);
        return obj;
    }

    static /* synthetic */ void deleteCommentById_aroundBody16(TaskServiceImpl ajc$this, long commentId, JoinPoint joinPoint) {
        Comment comment = (Comment)ajc$this.daoHandler.getCommentHandler().find(Long.valueOf(commentId));
        if (comment == null) {
            LOG.info((Object)("Can not find comment with ID: " + commentId));
            throw new CommentNotFoundException(commentId);
        }
        ajc$this.daoHandler.getCommentHandler().delete(comment);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Task", "task", "", "org.exoplatform.task.domain.Task"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskInfo", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:[Ljava.lang.String;:java.util.TimeZone", "id:param:values:timezone", "org.exoplatform.task.exception.TaskNotFoundException:org.exoplatform.task.exception.ParameterEntityException:org.exoplatform.task.exception.StatusNotFoundException", "org.exoplatform.task.domain.Task"), 101);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskOrder", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:org.exoplatform.task.domain.Status:[J", "currentTaskId:newStatus:orders", "", "void"), 282);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskCompleted", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.Boolean", "id:completed", "org.exoplatform.task.exception.TaskNotFoundException:org.exoplatform.task.exception.ParameterEntityException:org.exoplatform.task.exception.StatusNotFoundException", "org.exoplatform.task.domain.Task"), 290);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.domain.Task", "task", "", "void"), 298);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskById", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.TaskNotFoundException", "void"), 305);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneTaskById", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.TaskNotFoundException", "org.exoplatform.task.domain.Task"), 315);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCommentToTaskId", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:java.lang.String", "id:username:comment", "org.exoplatform.task.exception.TaskNotFoundException", "org.exoplatform.task.domain.Comment"), 354);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteCommentById", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "commentId", "org.exoplatform.task.exception.CommentNotFoundException", "void"), 382);
    }
}

