/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.util.StringTokenizer;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.UserService;

public final class CommentUtil {
    private CommentUtil() {
    }

    public static String formatMention(String text, UserService userService) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreElements()) {
            String username;
            User user;
            String next = (String)tokenizer.nextElement();
            if (next.length() == 0) continue;
            if (next.charAt(0) == '@' && (user = userService.loadUser(username = next.substring(1))) != null && !"guest".equals(user.getUsername())) {
                next = "<a href=\"/portal/intranet/profile/" + user.getUsername() + "\">" + user.getDisplayName() + "</a>";
            }
            sb.append(next);
            sb.append(' ');
        }
        return sb.toString();
    }
}

