/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.TaskBuilder;
import org.exoplatform.task.service.TaskParserPlugin;
import org.exoplatform.task.util.DateUtil;

public class DefaultParserPlugin
implements TaskParserPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(DefaultParserPlugin.class);
    private static final Map<String, Integer> DAY_OF_WEEKS = new HashMap<String, Integer>();
    private static final Map<String, Integer> MONTHS = new HashMap<String, Integer>();
    private Pattern ASSIGNEE_REGEX = Pattern.compile("(\\s)(@)([a-zA-Z]+)");
    private Pattern PRIORITY_REGEX = Pattern.compile("(\\s)(!)([a-zA-Z]+)");
    private Pattern TAG_REGEX = Pattern.compile("(\\s)(#)([0-9a-zA-Z_]+)");

    @Override
    public String parse(String input, ParserContext context, TaskBuilder builder) {
        input = this.parseAssignee(input, builder);
        input = this.parsePriority(input, builder);
        input = this.parseTag(input, builder);
        input = this.parseDueDate(input, builder, context);
        return input;
    }

    private String parseAssignee(String input, TaskBuilder builder) {
        Matcher m = this.ASSIGNEE_REGEX.matcher(input);
        while (m.find()) {
            String assignee = m.group(3);
            builder.withAssignee(assignee.trim());
        }
        String in = m.replaceAll(" ").trim();
        return in;
    }

    private String parsePriority(String input, TaskBuilder builder) {
        Matcher m = this.PRIORITY_REGEX.matcher(input);
        while (m.find()) {
            String priority = m.group(3);
            try {
                builder.withPriority(Priority.valueOf(priority.toUpperCase()));
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"Issue during parsing task priority: ", (Throwable)ex);
            }
        }
        String in = m.replaceAll(" ").trim();
        return in;
    }

    private String parseTag(String input, TaskBuilder builder) {
        Matcher m = this.TAG_REGEX.matcher(input);
        while (m.find()) {
            builder.addTag(m.group(3));
        }
        String in = m.replaceAll(" ").trim();
        return in;
    }

    private String parseDueDate(String input, TaskBuilder builder, ParserContext context) {
        StringTokenizer tokenizer = new StringTokenizer(input);
        StringBuilder retInput = new StringBuilder();
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            if (element.charAt(0) == '^') {
                Date dueDate = null;
                String param = element.substring(1).toLowerCase();
                dueDate = param.startsWith("next") && tokenizer.hasMoreElements() ? this.parseNextDateOf((String)tokenizer.nextElement(), context.getTimezone()) : this.parseDate(param, context.getTimezone());
                if (dueDate != null) {
                    builder.withDueDate(dueDate);
                    continue;
                }
                retInput.append(element).append(' ');
                continue;
            }
            retInput.append(element).append(' ');
        }
        return retInput.toString().trim();
    }

    private Date parseNextDateOf(String token, TimeZone timezone) {
        Calendar calendar = this.getCalendar(timezone);
        if ("week".equalsIgnoreCase(token)) {
            calendar.add(5, 7);
        } else if ("month".equalsIgnoreCase(token)) {
            calendar.add(2, 1);
        }
        return calendar.getTime();
    }

    private Date parseDate(String dateString, TimeZone timezone) {
        String month;
        Calendar calendar = this.getCalendar(timezone);
        if (dateString.equalsIgnoreCase("today")) {
            return calendar.getTime();
        }
        if ("Tomorrow".equalsIgnoreCase(dateString)) {
            calendar.add(5, 1);
            return calendar.getTime();
        }
        String key = dateString.toLowerCase();
        if (DAY_OF_WEEKS.containsKey(key)) {
            int dayOfWeek = DAY_OF_WEEKS.get(key);
            calendar.add(5, 1);
            while (dayOfWeek != calendar.get(7)) {
                calendar.add(5, 1);
            }
            return calendar.getTime();
        }
        StringTokenizer tokenizer = new StringTokenizer(dateString, "-");
        String day = (String)tokenizer.nextElement();
        try {
            long timeInMillis = calendar.getTimeInMillis();
            calendar.set(5, Integer.parseInt(day));
            if (timeInMillis > calendar.getTimeInMillis()) {
                calendar.add(2, 1);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (tokenizer.hasMoreElements() && MONTHS.containsKey(month = ((String)tokenizer.nextElement()).toLowerCase())) {
            calendar.set(2, MONTHS.get(month));
        }
        return calendar.getTime();
    }

    private Calendar getCalendar(TimeZone timezone) {
        Calendar calendar = DateUtil.newCalendarInstance(timezone);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar;
    }

    static {
        DAY_OF_WEEKS.put("monday", 2);
        DAY_OF_WEEKS.put("mon", 2);
        DAY_OF_WEEKS.put("tuesday", 3);
        DAY_OF_WEEKS.put("tue", 3);
        DAY_OF_WEEKS.put("wednesday", 4);
        DAY_OF_WEEKS.put("wed", 4);
        DAY_OF_WEEKS.put("thursday", 5);
        DAY_OF_WEEKS.put("thu", 5);
        DAY_OF_WEEKS.put("friday", 6);
        DAY_OF_WEEKS.put("fri", 6);
        DAY_OF_WEEKS.put("saturday", 7);
        DAY_OF_WEEKS.put("sat", 7);
        DAY_OF_WEEKS.put("sunday", 1);
        DAY_OF_WEEKS.put("sun", 1);
        MONTHS.put("january", 0);
        MONTHS.put("jan", 0);
        MONTHS.put("january", 1);
        MONTHS.put("feb", 1);
        MONTHS.put("march", 2);
        MONTHS.put("mar", 2);
        MONTHS.put("april", 3);
        MONTHS.put("apr", 3);
        MONTHS.put("may", 4);
        MONTHS.put("june", 5);
        MONTHS.put("jun", 5);
        MONTHS.put("july", 6);
        MONTHS.put("jul", 6);
        MONTHS.put("august", 7);
        MONTHS.put("aug", 7);
        MONTHS.put("september", 8);
        MONTHS.put("sep", 8);
        MONTHS.put("october", 9);
        MONTHS.put("oct", 9);
        MONTHS.put("november", 10);
        MONTHS.put("nov", 10);
        MONTHS.put("december", 11);
        MONTHS.put("dec", 11);
    }
}

