/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class DateUtil {
    public static final String DUE_DATE_FORMAT = "MMM dd";
    public static final String DUE_DATE_FORMAT_WITH_YEAR = "MMM dd, yyyy";

    public static boolean isOverdue(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        Calendar current = Calendar.getInstance(tz);
        current.set(11, 0);
        current.set(12, 0);
        current.set(13, 0);
        current.set(14, 0);
        return calendar.getTimeInMillis() < current.getTimeInMillis();
    }

    public static boolean isYesterday(Calendar calendar) {
        Calendar cal = DateUtil.newCalendarInstance(calendar.getTimeZone());
        cal.add(5, -1);
        return calendar.get(5) == cal.get(5) && calendar.get(2) == cal.get(2) && calendar.get(1) == cal.get(1);
    }

    public static boolean isToday(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        Calendar current = Calendar.getInstance(tz);
        return calendar.get(5) == current.get(5) && calendar.get(2) == current.get(2) && calendar.get(1) == current.get(1);
    }

    public static boolean isTomorrow(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        Calendar current = Calendar.getInstance(tz);
        current.add(5, 1);
        return calendar.get(5) == current.get(5) && calendar.get(2) == current.get(2) && calendar.get(1) == current.get(1);
    }

    public static String getDueDateLabel(Calendar calendar, ResourceBundle bundle) {
        if (calendar == null) {
            return bundle.getString("label.noDueDate");
        }
        if (DateUtil.isOverdue(calendar)) {
            return bundle.getString("label.overdue");
        }
        if (DateUtil.isToday(calendar)) {
            return bundle.getString("label.today");
        }
        if (DateUtil.isTomorrow(calendar)) {
            return bundle.getString("label.tomorrow");
        }
        return bundle.getString("label.upcoming");
    }

    public static String formatDueDate(Calendar calendar, ResourceBundle bundle) {
        if (calendar == null) {
            return "";
        }
        if (DateUtil.isYesterday(calendar)) {
            return bundle.getString("label.yesterday");
        }
        if (DateUtil.isToday(calendar)) {
            return bundle.getString("label.today");
        }
        if (DateUtil.isTomorrow(calendar)) {
            return bundle.getString("label.tomorrow");
        }
        Calendar current = Calendar.getInstance(calendar.getTimeZone());
        boolean isSameYear = current.get(1) == calendar.get(1);
        SimpleDateFormat df = new SimpleDateFormat(isSameYear ? DUE_DATE_FORMAT : DUE_DATE_FORMAT_WITH_YEAR);
        df.setCalendar(calendar);
        return df.format(calendar.getTime());
    }

    public static Calendar newCalendarInstance(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        return calendar;
    }
}

