/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.TaskServiceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskServiceTest {
    TaskService taskService;
    ListenerService listenerService;
    @Mock
    ExoContainer container;
    @Mock
    TaskHandler taskHandler;
    @Mock
    CommentHandler commentHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    DAOHandler daoHandler;
    @Mock
    UserService userService;
    @Captor
    ArgumentCaptor<Task> taskCaptor;
    @Captor
    ArgumentCaptor<Comment> commentCaptor;

    @Before
    public void setUp() throws Exception {
        PortalContainer.getInstance();
        this.listenerService = new ListenerService(new ExoContainerContext(this.container));
        this.taskService = new TaskServiceImpl(this.daoHandler, this.listenerService);
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getCommentHandler()).thenReturn((Object)this.commentHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.taskHandler.create(Matchers.any(Task.class))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.taskHandler.update(Matchers.any(Task.class))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_STATUS_ID))).thenReturn((Object)TestUtils.getDefaultStatus());
        Mockito.when((Object)this.commentHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_COMMENT_ID))).thenReturn((Object)TestUtils.getDefaultComment());
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
    }

    @After
    public void tearDown() {
        this.taskService = null;
        ConversationState.setCurrent(null);
    }

    @Test
    public void testTaskCreatedEvent() throws Exception {
        this.taskService.createTask(TestUtils.getDefaultTask());
    }

    @Test
    public void testUpdateTaskTitle() throws Exception {
        String newTitle = "newTitle";
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setTitle(newTitle);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        Assert.assertEquals((Object)newTitle, (Object)((Task)this.taskCaptor.getValue()).getTitle());
    }

    @Test
    public void testUpdateTaskDescription() throws ParameterEntityException, EntityNotFoundException {
        String newDescription = "This is a new description";
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setDescription(newDescription);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        Assert.assertEquals((Object)newDescription, (Object)((Task)this.taskCaptor.getValue()).getDescription());
    }

    @Test
    public void testUpdateTaskCompleted() throws ParameterEntityException, EntityNotFoundException {
        Boolean newCompleted = true;
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setCompleted(newCompleted.booleanValue());
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        Assert.assertEquals((Object)newCompleted, (Object)((Task)this.taskCaptor.getValue()).isCompleted());
    }

    @Test
    public void testUpdateTaskAssignee() throws ParameterEntityException, EntityNotFoundException {
        String newAssignee = "Tib";
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setAssignee(newAssignee);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        Assert.assertEquals((Object)newAssignee, (Object)((Task)this.taskCaptor.getValue()).getAssignee());
    }

    @Test
    public void testUpdateTaskCoworker() throws ParameterEntityException, EntityNotFoundException {
        HashSet<String> newCoworkers = new HashSet<String>();
        newCoworkers.add("Tib");
        newCoworkers.add("Trong");
        newCoworkers.add("Phuong");
        newCoworkers.add("Tuyen");
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setCoworker(newCoworkers);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        HashSet<String> coworker = new HashSet<String>();
        for (String v : newCoworkers) {
            coworker.add(v);
        }
        Assert.assertEquals(coworker, (Object)((Task)this.taskCaptor.getValue()).getCoworker());
    }

    @Test
    public void testUpdateTaskStatus() throws ParameterEntityException, EntityNotFoundException {
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setStatus((Status)this.statusHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_STATUS_ID)));
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        Assert.assertEquals((Object)TestUtils.getDefaultStatus(), (Object)((Task)this.taskCaptor.getValue()).getStatus());
    }

    @Test
    public void testUpdateTaskDueDate() throws ParameterEntityException, EntityNotFoundException, ParseException {
        String dueDate = "1989-01-19";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(dueDate);
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setDueDate(date);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update(this.taskCaptor.capture());
        Assert.assertEquals((Object)date, (Object)((Task)this.taskCaptor.getValue()).getDueDate());
    }

    @Test
    public void testDeleteTaskById() throws EntityNotFoundException {
        this.taskService.removeTask(TestUtils.EXISTING_TASK_ID);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).delete(this.taskCaptor.capture());
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)((Task)this.taskCaptor.getValue()).getId());
    }

    @Test
    public void testCloneTaskById() throws EntityNotFoundException {
        Task defaultTask = TestUtils.getDefaultTask();
        this.taskService.cloneTask(TestUtils.EXISTING_TASK_ID);
        ArgumentCaptor taskCaptor = ArgumentCaptor.forClass(Task.class);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).create(taskCaptor.capture());
        Assert.assertEquals((Object)("Copy of " + defaultTask.getTitle()), (Object)((Task)taskCaptor.getValue()).getTitle());
        Assert.assertEquals((Object)defaultTask.getDescription(), (Object)((Task)taskCaptor.getValue()).getDescription());
        Assert.assertEquals((Object)defaultTask.getPriority(), (Object)((Task)taskCaptor.getValue()).getPriority());
        Assert.assertEquals((Object)defaultTask.getContext(), (Object)((Task)taskCaptor.getValue()).getContext());
        Assert.assertEquals((Object)defaultTask.getAssignee(), (Object)((Task)taskCaptor.getValue()).getAssignee());
        Assert.assertEquals((Object)defaultTask.getStatus(), (Object)((Task)taskCaptor.getValue()).getStatus());
        Assert.assertEquals((Object)defaultTask.getCreatedBy(), (Object)((Task)taskCaptor.getValue()).getCreatedBy());
        Assert.assertFalse((defaultTask.getCreatedTime() == ((Task)taskCaptor.getValue()).getCreatedTime() ? 1 : 0) != 0);
        Assert.assertEquals((Object)defaultTask.getEndDate(), (Object)((Task)taskCaptor.getValue()).getEndDate());
        Assert.assertEquals((Object)defaultTask.getStartDate(), (Object)((Task)taskCaptor.getValue()).getStartDate());
        Assert.assertEquals((Object)defaultTask.getDueDate(), (Object)((Task)taskCaptor.getValue()).getDueDate());
    }

    @Test
    public void testAddSubComments() throws EntityNotFoundException {
        String username = "Tib";
        String comment = "Bla bla bla bla bla";
        String authorSubComment = "Tib2";
        String subCommentContent = "Bla bla bla bla bla sub comment";
        Mockito.when((Object)this.userService.loadUser((String)Matchers.eq((Object)username))).thenReturn((Object)new User(username, null, null, null, null, null, null));
        Mockito.when((Object)this.userService.loadUser((String)Matchers.eq((Object)authorSubComment))).thenReturn((Object)new User(authorSubComment, null, null, null, null, null, null));
        this.taskService.addComment(TestUtils.EXISTING_TASK_ID, username, comment);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).create(this.commentCaptor.capture());
        Comment parentComment = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)parentComment.getTask().getId());
        Assert.assertEquals((Object)username, (Object)parentComment.getAuthor());
        Assert.assertEquals((Object)comment, (Object)parentComment.getComment());
        long parentCommentId = parentComment.getId();
        this.taskService.addComment(TestUtils.EXISTING_TASK_ID, parentCommentId, authorSubComment, subCommentContent);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)2))).create(this.commentCaptor.capture());
        Comment subComment = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)subComment.getTask().getId());
        Assert.assertEquals((Object)authorSubComment, (Object)subComment.getAuthor());
        Assert.assertEquals((Object)subCommentContent, (Object)subComment.getComment());
    }

    @Test
    public void testAddCommentsByTaskId() throws EntityNotFoundException {
        String username = "Tib";
        String comment = "Bla bla bla bla bla";
        this.taskService.addComment(TestUtils.EXISTING_TASK_ID, username, comment);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).create(this.commentCaptor.capture());
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)((Comment)this.commentCaptor.getValue()).getTask().getId());
        Assert.assertEquals((Object)username, (Object)((Comment)this.commentCaptor.getValue()).getAuthor());
        Assert.assertEquals((Object)comment, (Object)((Comment)this.commentCaptor.getValue()).getComment());
    }

    @Test
    public void testDeleteCommentById() throws EntityNotFoundException {
        this.taskService.removeComment(TestUtils.EXISTING_COMMENT_ID);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).delete(this.commentCaptor.capture());
        Assert.assertEquals((long)TestUtils.EXISTING_COMMENT_ID, (long)((Comment)this.commentCaptor.getValue()).getId());
    }

    @Test(expected=EntityNotFoundException.class)
    public void testTaskNotFoundException() throws EntityNotFoundException {
        this.taskService.getTask(TestUtils.UNEXISTING_TASK_ID);
    }

    @Test(expected=EntityNotFoundException.class)
    public void testCommentNotFoundException() throws EntityNotFoundException {
        this.taskService.removeComment(TestUtils.UNEXISTING_COMMENT_ID);
    }
}

