/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.CommentUtil;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/tasks")
@Api(value="/tasks", description="Managing tasks")
@RolesAllowed(value={"users"})
public class TaskRestService
implements ResourceContainer {
    private static final int DEFAULT_LIMIT = 20;
    private static final Log LOG = ExoLogger.getLogger(TaskRestService.class);
    private TaskService taskService;
    private ProjectService projectService;
    private StatusService statusService;
    private UserService userService;
    private SpaceService spaceService;

    public TaskRestService(TaskService taskService, ProjectService projectService, StatusService statusService, UserService userService, SpaceService spaceService) {
        this.taskService = taskService;
        this.projectService = projectService;
        this.statusService = statusService;
        this.userService = userService;
        this.spaceService = spaceService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets uncompleted tasks of the authenticated user", httpMethod="GET", response=Response.class, notes="This returns uncompleted tasks of the authenticated user in the following cases: <br/><ul><li>The authenticated is the creator of the task</li><li>The authenticated is the assignee of the task</li><li>The authenticated is a coworker of the task</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getTasks(@ApiParam(value="Type of task to get (all, incoming, overdue)", required=false) @QueryParam(value="status") String status, @ApiParam(value="Search term", required=false) @QueryParam(value="q") String query, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of tasks or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        long tasksSize;
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        List<Object> tasks = null;
        if (StringUtils.isBlank((CharSequence)query)) {
            TaskType taskType;
            try {
                taskType = TaskType.valueOf(status.toUpperCase());
            }
            catch (Exception e) {
                taskType = TaskType.ALL;
            }
            if (limit <= 0) {
                limit = 20;
            }
            switch (taskType) {
                case INCOMING: {
                    ListAccess<Task> tasksListAccess = this.taskService.getIncomingTasks(currentUser);
                    tasks = Arrays.asList(tasksListAccess.load(offset, limit));
                    tasksSize = tasksListAccess.getSize();
                    break;
                }
                case OVERDUE: {
                    tasks = this.taskService.getOverdueTasks(currentUser, limit);
                    tasksSize = this.taskService.countOverdueTasks(currentUser);
                    break;
                }
                default: {
                    tasks = this.taskService.getUncompletedTasks(currentUser, limit);
                    tasksSize = this.taskService.countUncompletedTasks(currentUser);
                    break;
                }
            }
        } else {
            tasks = this.taskService.findTasks(currentUser, query, limit);
            tasks = tasks.stream().map(task -> {
                int commentCount;
                long taskId = ((Task)task).getId();
                try {
                    commentCount = this.taskService.getComments(taskId).getSize();
                }
                catch (Exception e) {
                    LOG.warn("Error retrieving task '{}' comments count", new Object[]{taskId, e});
                    commentCount = 0;
                }
                return new TaskModel((Task)task, commentCount);
            }).collect(Collectors.toList());
            tasksSize = this.taskService.countTasks(currentUser, query);
        }
        if (returnSize) {
            JSONObject tasksSizeJsonObject = new JSONObject();
            tasksSizeJsonObject.put("size", tasksSize);
            tasksSizeJsonObject.put("tasks", tasks);
            return Response.ok((Object)tasksSizeJsonObject).build();
        }
        return Response.ok(tasks).build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific task by id", httpMethod="PUT", response=Response.class, notes="This updates the task if the authenticated user has permissions to view the objects linked to this task.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response updateTaskById(@ApiParam(value="Task id", required=true) @PathParam(value="id") long id, @ApiParam(value="task object to be updated", required=true) Task updatedTask) throws Exception {
        if (updatedTask == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!TaskUtil.hasEditPermission(task)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        task = this.taskService.updateTask(updatedTask);
        return Response.ok((Object)task).build();
    }

    @GET
    @Path(value="projects")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets projects", httpMethod="GET", response=Response.class, notes="This returns projects of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getProjects() {
        List<Project> projects = ProjectUtil.getProjectTree(null, this.projectService);
        JSONArray projectsJsonArray = new JSONArray();
        try {
            projectsJsonArray = this.buildJSON(projectsJsonArray, projects);
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting projects", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)projectsJsonArray.toString()).build();
    }

    @GET
    @Path(value="projects/status/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the default status by project id", httpMethod="GET", response=Response.class, notes="This returns the default status by project id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDefaultStatusByProjectId(@ApiParam(value="Project id", required=true) @PathParam(value="id") long id) throws EntityNotFoundException {
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        Project project = this.projectService.getProject(id);
        if (project == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!project.canView(currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Status status = this.statusService.getDefaultStatus(id);
        return Response.ok((Object)status).build();
    }

    @GET
    @Path(value="projects/statuses/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the statuses by project id", httpMethod="GET", response=Response.class, notes="This returns the statuses by project id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getStatusesByProjectId(@ApiParam(value="Project id", required=true) @PathParam(value="id") long id) throws EntityNotFoundException {
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        Project project = this.projectService.getProject(id);
        if (project == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!project.canView(currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<Status> projectStatuses = this.statusService.getStatuses(id);
        return Response.ok(projectStatuses).build();
    }

    @GET
    @Path(value="labels")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets labels of the authenticated user", httpMethod="GET", response=Response.class, notes="This returns labels of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getLabels() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        List<Object> labels = new ArrayList();
        labels = Arrays.asList(ListUtil.load(this.taskService.findLabelsByUser(currentUser), 0, -1));
        return Response.ok(labels).build();
    }

    @GET
    @Path(value="labels/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets labels of a specific task by id", httpMethod="GET", response=Response.class, notes="This returns labels of a specific task by id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getLabelsByTaskId(@ApiParam(value="Task id", required=true) @PathParam(value="id") long id) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        List<Object> labels = new ArrayList();
        try {
            labels = Arrays.asList(ListUtil.load(this.taskService.findLabelsByTask(id, currentUser), 0, -1));
        }
        catch (EntityNotFoundException e) {
            LOG.error((Object)"Error getting label by task id", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok(labels).build();
    }

    @POST
    @Path(value="labels/{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds a specific task by id to a label", httpMethod="POST", response=Response.class, notes="This adds a specific task by id to a label")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response addTaskToLabel(@ApiParam(value="label", required=true) Label addedLabel, @ApiParam(value="Task id", required=true) @PathParam(value="id") long id) throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (addedLabel == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!TaskUtil.hasEditPermission(task)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (addedLabel.getId() == 0L) {
            addedLabel.setUsername(currentUser);
            Label label = this.taskService.createLabel(addedLabel);
            this.taskService.addTaskToLabel(id, label.getId());
        } else {
            this.taskService.addTaskToLabel(id, addedLabel.getId());
        }
        return Response.ok((Object)addedLabel).build();
    }

    @DELETE
    @Path(value="labels/{id}/{labelId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific task association to a specific label", httpMethod="DELETE", response=Response.class, notes="This deletes a specific task association to a specific label")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response removeTaskFromLabel(@ApiParam(value="label id", required=true) @PathParam(value="labelId") long labelId, @ApiParam(value="Task id", required=true) @PathParam(value="id") long id) throws Exception {
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Label label = this.taskService.getLabel(labelId);
        if (label == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!TaskUtil.hasEditPermission(task)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.taskService.removeTaskFromLabel(id, labelId);
        return Response.ok((Object)label).build();
    }

    @GET
    @Path(value="logs/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a logs of a specific task", httpMethod="GET", response=Response.class, notes="This returns a logs of a specific task")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getTaskLogs(@ApiParam(value="Task id", required=true) @PathParam(value="id") long id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="-1") @QueryParam(value="limit") int limit) throws Exception {
        ChangeLog[] arr;
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!TaskUtil.hasViewPermission(task)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (limit == 0) {
            limit = -1;
        }
        if ((arr = ListUtil.load(this.taskService.getTaskLogs(id), offset, limit)) == null) {
            return Response.ok(Collections.emptyList()).build();
        }
        LinkedList<ChangeLog> logs = new LinkedList<ChangeLog>(Arrays.asList(arr));
        Collections.sort(logs);
        List<ChangeLogEntry> changeLogEntries = this.changeLogsToChangeLogEntries(logs);
        return Response.ok(changeLogEntries).build();
    }

    @GET
    @Path(value="comments/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a comment list of a specific task", httpMethod="GET", response=Response.class, notes="This returns a comment list of a specific task")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response getTaskComments(@ApiParam(value="Task id", required=true) @PathParam(value="id") long id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="-1") @QueryParam(value="limit") int limit) throws Exception {
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!TaskUtil.hasViewPermission(task)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ListAccess<Comment> commentsListAccess = this.taskService.getComments(id);
        if (limit == 0) {
            limit = -1;
        }
        List<Object> comments = Arrays.asList(commentsListAccess.load(offset, limit));
        this.taskService.loadSubComments(comments);
        ArrayList<CommentModel> commentModelsList = new ArrayList<CommentModel>();
        for (Comment comment : comments) {
            CommentModel commentModel = this.addCommentModel(comment, commentModelsList);
            if (comment.getSubComments().isEmpty()) continue;
            ArrayList<CommentModel> subCommentsModelsList = new ArrayList<CommentModel>();
            for (Comment subComment : comment.getSubComments()) {
                this.addCommentModel(subComment, subCommentsModelsList);
            }
            commentModel.setSubComments(subCommentsModelsList);
        }
        Collections.reverse(commentModelsList);
        return Response.ok(commentModelsList).build();
    }

    @POST
    @Path(value="comments/{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds comment to a specific task by id", httpMethod="POST", response=Response.class, notes="This Adds comment to a specific task by id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response addTaskComment(@ApiParam(value="Comment text", required=true) String commentText, @ApiParam(value="Task id", required=true) @PathParam(value="id") long id) throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (commentText == null || commentText.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!TaskUtil.hasEditPermission(task)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Comment addedComment = this.taskService.addComment(id, currentUser, commentText = URLDecoder.decode(commentText, "UTF-8"));
        if (addedComment != null) {
            addedComment = this.taskService.getComment(addedComment.getId());
        }
        CommentModel commentModel = new CommentModel(addedComment, this.userService.loadUser(currentUser), commentText);
        return Response.ok((Object)commentModel).build();
    }

    @POST
    @Path(value="comments/{commentId}/{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds a sub comment to a specific parent comment by id and a specific task by id", httpMethod="POST", response=Response.class, notes="This Adds sub comment to a parent comment in specific task by id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response addTaskSubComment(@ApiParam(value="Comment text", required=true) String commentText, @ApiParam(value="Comment id", required=true) @PathParam(value="commentId") long commentId, @ApiParam(value="Task id", required=true) @PathParam(value="id") long id) throws Exception {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        Task task = this.taskService.getTask(id);
        if (task == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!TaskUtil.hasEditPermission(task)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (commentText == null || commentText.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Comment addedComment = this.taskService.addComment(id, commentId, currentUser, commentText = URLDecoder.decode(commentText, "UTF-8"));
        if (addedComment != null) {
            addedComment = this.taskService.getComment(addedComment.getId());
        }
        CommentModel commentModel = new CommentModel(addedComment, this.userService.loadUser(currentUser), commentText);
        return Response.ok((Object)commentModel).build();
    }

    @DELETE
    @Path(value="comments/{commentId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific task comment by id", httpMethod="DELETE", response=Response.class, notes="This deletes a specific task comment by id")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=404, message="Resource not found")})
    public Response deleteComment(@ApiParam(value="Comment id", required=true) @PathParam(value="commentId") long commentId) throws Exception {
        Comment comment = this.taskService.getComment(commentId);
        if (comment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        if (!TaskUtil.canDeleteComment(currentIdentity, comment)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.taskService.removeComment(commentId);
        return Response.ok((Object)comment).build();
    }

    @GET
    @Path(value="usersToMention/{query}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets users to mention in comment", httpMethod="GET", response=Response.class, notes="This returns users to mention in comment")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response findUsersToMention(@ApiParam(value="Query", required=true) @PathParam(value="query") String query) throws Exception {
        ListAccess<User> list = this.userService.findUserByName(query);
        JSONArray usersJsonArray = new JSONArray();
        for (User user : (User[])list.load(0, 10)) {
            JSONObject userJson = new JSONObject();
            userJson.put("id", (Object)("@" + user.getUsername()));
            userJson.put("name", (Object)user.getDisplayName());
            userJson.put("avatar", (Object)user.getAvatar());
            userJson.put("type", (Object)"contact");
            usersJsonArray.put((Object)userJson);
        }
        return Response.ok((Object)usersJsonArray.toString()).build();
    }

    @GET
    @Path(value="users/{query}/{projectName}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets users by query and project name", httpMethod="GET", response=Response.class, notes="This returns users by query and project name")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getUsersByQueryAndProjectName(@ApiParam(value="Query", required=true) @PathParam(value="query") String query, @ApiParam(value="projectName", required=true) @PathParam(value="projectName") String projectName) throws Exception {
        ListAccess<User> usersList = this.userService.findUserByName(query);
        JSONArray usersJsonArray = new JSONArray();
        for (User user : (User[])usersList.load(0, 10)) {
            JSONObject userJson = new JSONObject();
            Space space = this.spaceService.getSpaceByPrettyName(projectName);
            if (space != null && !this.spaceService.isMember(space, user.getUsername())) continue;
            userJson.put("username", (Object)user.getUsername());
            userJson.put("fullname", (Object)user.getDisplayName());
            userJson.put("avatar", (Object)user.getAvatar());
            usersJsonArray.put((Object)userJson);
        }
        return Response.ok((Object)usersJsonArray.toString()).build();
    }

    private CommentModel addCommentModel(Comment comment, List<CommentModel> commentModelsList) {
        CommentModel commentModel;
        User user = this.userService.loadUser(comment.getAuthor());
        Status taskStatus = comment.getTask().getStatus();
        if (taskStatus != null) {
            comment.getTask().setStatus(taskStatus.clone());
        }
        if ((commentModel = new CommentModel(comment, user, CommentUtil.formatMention(comment.getComment(), this.userService))).getSubComments() == null) {
            commentModel.setSubComments(new ArrayList<CommentModel>());
        }
        commentModelsList.add(commentModel);
        return commentModel;
    }

    private JSONArray buildJSON(JSONArray projectsJsonArray, List<Project> projects) throws JSONException {
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        for (Project project : projects) {
            if (!project.canView(currentUser)) continue;
            long projectId = project.getId();
            JSONObject projectJson = new JSONObject();
            projectJson.put("id", projectId);
            projectJson.put("name", (Object)project.getName());
            projectJson.put("color", (Object)project.getColor());
            projectJson.put("participator", this.projectService.getParticipator(projectId));
            projectJson.put("hiddenOn", project.getHiddenOn());
            projectJson.put("manager", this.projectService.getManager(projectId));
            projectJson.put("children", this.projectService.getSubProjects(projectId));
            projectJson.put("dueDate", (Object)project.getDueDate());
            projectJson.put("calendarIntegrated", project.isCalendarIntegrated());
            projectJson.put("description", (Object)project.getDescription());
            projectJson.put("status", (Object)this.statusService.getStatus(projectId));
            projectsJsonArray.put((Object)projectJson);
            if (this.projectService.getSubProjects(projectId) == null) continue;
            List<Project> children = Arrays.asList(ListUtil.load(this.projectService.getSubProjects(projectId), 0, -1));
            this.buildJSON(projectsJsonArray, children);
        }
        return projectsJsonArray;
    }

    private ChangeLogEntry changeLogToChangeLogEntry(ChangeLog changeLog) {
        return new ChangeLogEntry(changeLog, this.userService);
    }

    private List<ChangeLogEntry> changeLogsToChangeLogEntries(List<ChangeLog> ChangeLogs) {
        return ChangeLogs.stream().filter(Objects::nonNull).map(this::changeLogToChangeLogEntry).collect(Collectors.toList());
    }

    private static enum TaskType {
        ALL,
        INCOMING,
        OVERDUE;

    }
}

